/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.admin;

import java.util.Objects;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class AbortTransactionSpec {
    private final TopicPartition topicPartition;
    private final long producerId;
    private final short producerEpoch;
    private final int coordinatorEpoch;

    public AbortTransactionSpec(TopicPartition topicPartition, long producerId, short producerEpoch, int coordinatorEpoch) {
        this.topicPartition = topicPartition;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.coordinatorEpoch = coordinatorEpoch;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbortTransactionSpec that = (AbortTransactionSpec)o;
        return this.producerId == that.producerId && this.producerEpoch == that.producerEpoch && this.coordinatorEpoch == that.coordinatorEpoch && Objects.equals(this.topicPartition, that.topicPartition);
    }

    public int hashCode() {
        return Objects.hash(this.topicPartition, this.producerId, this.producerEpoch, this.coordinatorEpoch);
    }

    public String toString() {
        return "AbortTransactionSpec(topicPartition=" + this.topicPartition + ", producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", coordinatorEpoch=" + this.coordinatorEpoch + ')';
    }
}

