/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.types;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeRoot;
import org.apache.flink.cdc.common.types.DataTypeVisitor;

@PublicEvolving
public final class TimeType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final int MIN_PRECISION = 0;
    public static final int MAX_PRECISION = 9;
    public static final int DEFAULT_PRECISION = 0;
    private static final String FORMAT = "TIME(%d)";
    private final int precision;

    public TimeType(boolean isNullable, int precision) {
        super(isNullable, DataTypeRoot.TIME_WITHOUT_TIME_ZONE);
        if (precision < 0 || precision > 9) {
            throw new IllegalArgumentException(String.format("Time precision must be between %d and %d (both inclusive).", 0, 9));
        }
        this.precision = precision;
    }

    public TimeType(int precision) {
        this(true, precision);
    }

    public TimeType() {
        this(0);
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new TimeType(isNullable, this.precision);
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, this.precision);
    }

    @Override
    public List<DataType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeType timeType = (TimeType)o;
        return this.precision == timeType.precision;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision);
    }
}

