/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.pipeline;

import java.time.Duration;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.configuration.ConfigOption;
import org.apache.flink.cdc.common.configuration.ConfigOptions;
import org.apache.flink.cdc.common.configuration.description.Description;
import org.apache.flink.cdc.common.configuration.description.ListElement;
import org.apache.flink.cdc.common.configuration.description.TextElement;
import org.apache.flink.cdc.common.pipeline.SchemaChangeBehavior;

@PublicEvolving
public class PipelineOptions {
    public static final Duration DEFAULT_SCHEMA_OPERATOR_RPC_TIMEOUT = Duration.ofMinutes(3L);
    public static final ConfigOption<String> PIPELINE_NAME = ConfigOptions.key("name").stringType().defaultValue("Flink CDC Pipeline Job").withDescription("The name of the pipeline");
    public static final ConfigOption<Integer> PIPELINE_PARALLELISM = ConfigOptions.key("parallelism").intType().noDefaultValue().withDescription("Parallelism of the pipeline");
    public static final ConfigOption<SchemaChangeBehavior> PIPELINE_SCHEMA_CHANGE_BEHAVIOR = ConfigOptions.key("schema.change.behavior").enumType(SchemaChangeBehavior.class).defaultValue(SchemaChangeBehavior.EVOLVE).withDescription(Description.builder().text("Behavior for handling schema change events. ").linebreak().add(ListElement.list(TextElement.text("EVOLVE: Apply schema changes to downstream. This requires sink to support handling schema changes."), TextElement.text("IGNORE: Drop all schema change events."), TextElement.text("EXCEPTION: Throw an exception to terminate the sync pipeline."))).build());
    public static final ConfigOption<String> PIPELINE_LOCAL_TIME_ZONE = ConfigOptions.key("local-time-zone").stringType().defaultValue("systemDefault").withDescription(Description.builder().text("The local time zone defines current session time zone id. ").linebreak().text("It is used when converting to/from <code>TIMESTAMP WITH LOCAL TIME ZONE</code>. Internally, timestamps with local time zone are always represented in the UTC time zone. However, when converting to data types that don't include a time zone (e.g. TIMESTAMP, STRING), the session time zone is used during conversion. The input of option is either a full name such as \"America/Los_Angeles\", or a custom timezone id such as \"GMT-08:00\".").build());
    public static final ConfigOption<String> PIPELINE_SCHEMA_OPERATOR_UID = ConfigOptions.key("schema.operator.uid").stringType().defaultValue("$$_schema_operator_$$").withDescription("The unique ID for schema operator. This ID will be used for inter-operator communications and must be unique across operators.");
    public static final ConfigOption<Duration> PIPELINE_SCHEMA_OPERATOR_RPC_TIMEOUT = ConfigOptions.key("schema-operator.rpc-timeout").durationType().defaultValue(DEFAULT_SCHEMA_OPERATOR_RPC_TIMEOUT).withDescription("The timeout time for SchemaOperator to wait downstream SchemaChangeEvent applying finished, the default value is 3 minutes.");

    private PipelineOptions() {
    }
}

