/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.source.event;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;

public class ReaderRegistrationEvent
implements OperatorEvent {
    private static final long serialVersionUID = 1L;
    private final int subtaskId;
    private final String location;
    private final ArrayList<byte[]> splits;

    public ReaderRegistrationEvent(int subtaskId, String location) {
        this.subtaskId = subtaskId;
        this.location = location;
        this.splits = new ArrayList();
    }

    ReaderRegistrationEvent(int subtaskId, String location, ArrayList<byte[]> splits) {
        this.subtaskId = subtaskId;
        this.location = location;
        this.splits = splits;
    }

    public static <SplitT extends SourceSplit> ReaderRegistrationEvent createReaderRegistrationEvent(int subtaskId, String location, List<SplitT> splits, SimpleVersionedSerializer<SplitT> splitSerializer) throws IOException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (SourceSplit split : splits) {
            result.add(splitSerializer.serialize((Object)split));
        }
        return new ReaderRegistrationEvent(subtaskId, location, result);
    }

    public <SplitT extends SourceSplit> List<SplitT> splits(SimpleVersionedSerializer<SplitT> splitSerializer) throws IOException {
        if (this.splits.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SourceSplit> result = new ArrayList<SourceSplit>(this.splits.size());
        for (byte[] serializedSplit : this.splits) {
            result.add((SourceSplit)splitSerializer.deserialize(splitSerializer.getVersion(), serializedSplit));
        }
        return result;
    }

    public int subtaskId() {
        return this.subtaskId;
    }

    public String location() {
        return this.location;
    }

    public String toString() {
        return String.format("ReaderRegistrationEvent[subtaskId = %d, location = %s)", this.subtaskId, this.location);
    }
}

