/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.event;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.watermark.BoolWatermark;
import org.apache.flink.api.common.watermark.LongWatermark;
import org.apache.flink.api.common.watermark.Watermark;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.RuntimeEvent;

@Internal
public class WatermarkEvent
extends RuntimeEvent {
    private static final int TAG_LONG_GENERALIZED_WATERMARK = 0;
    private static final int TAG_BOOL_GENERALIZED_WATERMARK = 1;
    private Watermark watermark;
    private boolean isAligned = false;

    public WatermarkEvent() {
    }

    public WatermarkEvent(Watermark watermark, boolean isAligned) {
        this.watermark = watermark;
        this.isAligned = isAligned;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeUTF(this.watermark.getIdentifier());
        out.writeBoolean(this.isAligned);
        if (this.watermark instanceof LongWatermark) {
            out.writeInt(0);
            out.writeLong(((LongWatermark)this.watermark).getValue());
        } else if (this.watermark instanceof BoolWatermark) {
            out.writeInt(1);
            out.writeBoolean(((BoolWatermark)this.watermark).getValue());
        } else {
            throw new IllegalArgumentException("Unsupported watermark type: " + String.valueOf(this.watermark.getClass()));
        }
    }

    public void read(DataInputView in) throws IOException {
        String identifier = in.readUTF();
        this.isAligned = in.readBoolean();
        int watermarkTypeTag = in.readInt();
        if (watermarkTypeTag == 0) {
            long value = in.readLong();
            this.watermark = new LongWatermark(value, identifier);
        } else if (watermarkTypeTag == 1) {
            boolean value = in.readBoolean();
            this.watermark = new BoolWatermark(value, identifier);
        } else {
            throw new IllegalArgumentException("Unknown watermark class tag: " + watermarkTypeTag);
        }
    }

    public Watermark getWatermark() {
        return this.watermark;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatermarkEvent that = (WatermarkEvent)o;
        return this.isAligned == that.isAligned && Objects.equals(this.watermark, that.watermark);
    }

    public int hashCode() {
        return Objects.hash(this.watermark, this.isAligned);
    }

    public String toString() {
        return "WatermarkEvent{watermarkElement=" + String.valueOf(this.watermark) + ", isAligned=" + this.isAligned + "}";
    }
}

