/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;

public class ClusterInformation
implements Serializable {
    private static final long serialVersionUID = 316958921518479205L;
    private final String blobServerHostname;
    private final int blobServerPort;

    public ClusterInformation(String blobServerHostname, int blobServerPort) {
        this.blobServerHostname = (String)Preconditions.checkNotNull((Object)blobServerHostname);
        Preconditions.checkArgument((0 < blobServerPort && blobServerPort < 65536 ? 1 : 0) != 0, (Object)("The blob port must between 0 and 65_536. However, it was " + blobServerPort + "."));
        this.blobServerPort = blobServerPort;
    }

    public String getBlobServerHostname() {
        return this.blobServerHostname;
    }

    public int getBlobServerPort() {
        return this.blobServerPort;
    }

    public String toString() {
        return "ClusterInformation{blobServerHostname='" + this.blobServerHostname + "', blobServerPort=" + this.blobServerPort + "}";
    }
}

