/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.watermarkstatus;

import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WatermarkStatusTest {
    WatermarkStatusTest() {
    }

    @Test
    void testIllegalCreationThrowsException() {
        Assertions.assertThatThrownBy(() -> new WatermarkStatus(32)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testEquals() {
        WatermarkStatus idleStatus = new WatermarkStatus(-1);
        WatermarkStatus activeStatus = new WatermarkStatus(0);
        Assertions.assertThat((Object)idleStatus).isEqualTo((Object)WatermarkStatus.IDLE);
        Assertions.assertThat((boolean)idleStatus.isIdle()).isTrue();
        Assertions.assertThat((boolean)idleStatus.isActive()).isFalse();
        Assertions.assertThat((Object)activeStatus).isEqualTo((Object)WatermarkStatus.ACTIVE);
        Assertions.assertThat((boolean)activeStatus.isActive()).isTrue();
        Assertions.assertThat((boolean)activeStatus.isIdle()).isFalse();
    }

    @Test
    void testTypeCasting() {
        WatermarkStatus status = WatermarkStatus.ACTIVE;
        Assertions.assertThat((boolean)status.isWatermarkStatus()).isTrue();
        Assertions.assertThat((boolean)status.isRecord()).isFalse();
        Assertions.assertThat((boolean)status.isWatermark()).isFalse();
        Assertions.assertThat((boolean)status.isLatencyMarker()).isFalse();
        Assertions.assertThatThrownBy(() -> ((WatermarkStatus)status).asWatermark()).isInstanceOf(ClassCastException.class);
        Assertions.assertThatThrownBy(() -> ((WatermarkStatus)status).asRecord()).isInstanceOf(ClassCastException.class);
        Assertions.assertThatThrownBy(() -> ((WatermarkStatus)status).asLatencyMarker()).isInstanceOf(ClassCastException.class);
    }
}

