/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFilterFunction;
import org.apache.flink.streaming.api.operators.StreamFilter;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StreamFilterTest {
    StreamFilterTest() {
    }

    @Test
    void testFilter() throws Exception {
        StreamFilter operator = new StreamFilter((FilterFunction)new MyFilter());
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(operator);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)1, initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)2, initialTime + 2L));
        testHarness.processWatermark(new Watermark(initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)3, initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)4, initialTime + 4L));
        testHarness.processElement(new StreamRecord((Object)5, initialTime + 5L));
        testHarness.processElement(new StreamRecord((Object)6, initialTime + 6L));
        testHarness.processElement(new StreamRecord((Object)7, initialTime + 7L));
        expectedOutput.add(new StreamRecord((Object)2, initialTime + 2L));
        expectedOutput.add(new Watermark(initialTime + 2L));
        expectedOutput.add(new StreamRecord((Object)4, initialTime + 4L));
        expectedOutput.add(new StreamRecord((Object)6, initialTime + 6L));
        TestHarnessUtil.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testOpenClose() throws Exception {
        StreamFilter operator = new StreamFilter((FilterFunction)new TestOpenCloseFilterFunction());
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(operator);
        long initialTime = 0L;
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)"fooHello", initialTime));
        testHarness.processElement(new StreamRecord((Object)"bar", initialTime));
        testHarness.close();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestOpenCloseFilterFunction.closeCalled).as("RichFunction methods where not called.", new Object[0])).isTrue();
        ((AbstractCollectionAssert)Assertions.assertThat(testHarness.getOutput()).as("Output contains no elements.", new Object[0])).isNotEmpty();
    }

    private static class TestOpenCloseFilterFunction
    extends RichFilterFunction<String> {
        private static final long serialVersionUID = 1L;
        public static boolean openCalled = false;
        public static boolean closeCalled = false;

        private TestOpenCloseFilterFunction() {
        }

        public void open(OpenContext openContext) throws Exception {
            super.open(openContext);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)openCalled).as("Open was called before.", new Object[0])).isFalse();
            openCalled = true;
        }

        public void close() throws Exception {
            super.close();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)openCalled).as("Open was not called before close.", new Object[0])).isTrue();
            closeCalled = true;
        }

        public boolean filter(String value) throws Exception {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)openCalled).as("Open was not called before run.", new Object[0])).isTrue();
            return value.startsWith("foo");
        }
    }

    static class MyFilter
    implements FilterFunction<Integer> {
        private static final long serialVersionUID = 1L;

        MyFilter() {
        }

        public boolean filter(Integer value) throws Exception {
            return value % 2 == 0;
        }
    }
}

