/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.io.network.netty.exception.RemoteTransportException;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.SerializedThrowable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

class SerializedThrowableTest {
    SerializedThrowableTest() {
    }

    @Test
    void testIdenticalMessageAndStack() {
        try {
            IllegalArgumentException original = new IllegalArgumentException("test message");
            SerializedThrowable serialized = new SerializedThrowable((Throwable)original);
            Assertions.assertThat((String)ExceptionUtils.stringifyException((Throwable)original)).isEqualTo(ExceptionUtils.stringifyException((Throwable)serialized));
            Assertions.assertThat((Object[])original.getStackTrace()).isEqualTo((Object)serialized.getStackTrace());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testSerialization() {
        try {
            ClassLoaderUtils.ObjectAndClassLoader outsideClassLoading = ClassLoaderUtils.createExceptionObjectFromNewClassLoader();
            ClassLoader loader = outsideClassLoading.getClassLoader();
            Exception userException = (Exception)outsideClassLoading.getObject();
            Class<?> clazz = userException.getClass();
            byte[] serializedBytes = InstantiationUtil.serializeObject((Object)userException);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> InstantiationUtil.deserializeObject((byte[])serializedBytes, (ClassLoader)this.getClass().getClassLoader())).withFailMessage("should fail with a class not found exception", new Object[0])).isInstanceOf(ClassNotFoundException.class);
            SerializedThrowable serialized = new SerializedThrowable((Throwable)userException);
            Assertions.assertThat((String)ExceptionUtils.stringifyException((Throwable)userException)).isEqualTo(ExceptionUtils.stringifyException((Throwable)serialized));
            Assertions.assertThat((Object[])userException.getStackTrace()).isEqualTo((Object)serialized.getStackTrace());
            Exception userException2 = new Exception("error");
            SerializedThrowable serialized2 = new SerializedThrowable((Throwable)userException2);
            String result = String.format("%s: %s", userException2.getClass().getName(), userException2.getMessage());
            Assertions.assertThat((Throwable)serialized2).hasMessage(result);
            SerializedThrowable copy = (SerializedThrowable)CommonTestUtils.createCopySerializable((Serializable)serialized);
            Assertions.assertThat((String)ExceptionUtils.stringifyException((Throwable)userException)).isEqualTo(ExceptionUtils.stringifyException((Throwable)copy));
            Assertions.assertThat((Object[])userException.getStackTrace()).isEqualTo((Object)copy.getStackTrace());
            Throwable deserialized = copy.deserializeError(loader);
            Assertions.assertThat((Throwable)deserialized).isInstanceOf(clazz);
            Throwable wronglyDeserialized = copy.deserializeError(this.getClass().getClassLoader());
            Assertions.assertThat((String)ExceptionUtils.stringifyException((Throwable)userException)).isEqualTo(ExceptionUtils.stringifyException((Throwable)wronglyDeserialized));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCauseChaining() {
        Exception cause2 = new Exception("level2");
        Exception cause1 = new Exception("level1", cause2);
        Exception root = new Exception("level0", cause1);
        SerializedThrowable st = new SerializedThrowable((Throwable)root);
        Assertions.assertThat((Throwable)st).hasMessage("java.lang.Exception: level0");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)st.getCause()).isNotNull()).hasMessage("java.lang.Exception: level1");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)st.getCause().getCause()).isNotNull()).hasMessage("java.lang.Exception: level2");
    }

    @Test
    void testCyclicCauseChaining() {
        Exception cause3 = new Exception("level3");
        Exception cause2 = new Exception("level2", cause3);
        Exception cause1 = new Exception("level1", cause2);
        Exception root = new Exception("level0", cause1);
        cause3.initCause(cause1);
        SerializedThrowable st = new SerializedThrowable((Throwable)root);
        Assertions.assertThat((Object[])root.getStackTrace()).isEqualTo((Object)st.getStackTrace());
        Assertions.assertThat((String)ExceptionUtils.stringifyException((Throwable)root)).isEqualTo(ExceptionUtils.stringifyException((Throwable)st));
    }

    @Test
    void testCopyPreservesCause() {
        Exception original = new Exception("original message");
        Exception parent = new Exception("parent message", original);
        SerializedThrowable serialized = new SerializedThrowable((Throwable)parent);
        Assertions.assertThat((Throwable)serialized.getCause()).isNotNull();
        SerializedThrowable copy = new SerializedThrowable((Throwable)serialized);
        Assertions.assertThat((Throwable)copy).hasMessage("org.apache.flink.util.SerializedThrowable: java.lang.Exception: parent message");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)copy.getCause()).isNotNull()).hasMessage("java.lang.Exception: original message");
    }

    @Test
    void testSuppressedTransferring() {
        Exception root = new Exception("root");
        Exception suppressed = new Exception("suppressed");
        root.addSuppressed(suppressed);
        SerializedThrowable serializedThrowable = new SerializedThrowable((Throwable)root);
        Assertions.assertThat((Object[])serializedThrowable.getSuppressed()).hasSize(1);
        Throwable actualSuppressed = serializedThrowable.getSuppressed()[0];
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualSuppressed).isInstanceOf(SerializedThrowable.class)).hasMessage("java.lang.Exception: suppressed");
    }

    @Test
    void testCopySuppressed() {
        Exception root = new Exception("root");
        Exception suppressed = new Exception("suppressed");
        root.addSuppressed(suppressed);
        SerializedThrowable serializedThrowable = new SerializedThrowable((Throwable)root);
        SerializedThrowable copy = new SerializedThrowable((Throwable)serializedThrowable);
        Assertions.assertThat((Object[])copy.getSuppressed()).hasSize(1);
        Throwable actualSuppressed = copy.getSuppressed()[0];
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualSuppressed).isInstanceOf(SerializedThrowable.class)).hasMessage("java.lang.Exception: suppressed");
    }

    @Test
    void testCyclicSuppressedThrowableSerialized() {
        SerializedThrowable serializedThrowable = new SerializedThrowable(SerializedThrowableTest.mockThrowable());
        Assertions.assertThat((Throwable)serializedThrowable).isNotNull();
    }

    @Test
    @Timeout(value=5L, unit=TimeUnit.SECONDS)
    void testCyclicSuppressedThrowableConcurrentSerialized() throws InterruptedException {
        Throwable throwable = SerializedThrowableTest.mockThrowable();
        int threadNum = 16;
        CountDownLatch countDownLatch = new CountDownLatch(threadNum);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < threadNum; ++i) {
            String threadName = "thread-" + i;
            Thread t = SerializedThrowableTest.createThread(countDownLatch, throwable, threadName);
            t.start();
            countDownLatch.countDown();
            threads.add(t);
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }

    private static Thread createThread(CountDownLatch countDownLatch, Throwable throwable, String threadName) {
        Thread t = new Thread(() -> {
            try {
                countDownLatch.await();
                SerializedThrowable serializedThrowable = new SerializedThrowable(throwable);
                Assertions.assertThat((Throwable)serializedThrowable).isNotNull();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        t.setName(threadName);
        return t;
    }

    private static Throwable mockThrowable() {
        InetSocketAddress remoteAddr = new InetSocketAddress(80);
        RemoteTransportException remoteTransportException = new RemoteTransportException("Connection unexpectedly closed by remote task manager '" + String.valueOf(remoteAddr) + "'. This might indicate that the remote task manager was lost.", (SocketAddress)remoteAddr, (Throwable)new IOException("connection reset by peer."));
        RuntimeException runtimeException = new RuntimeException((Throwable)remoteTransportException);
        remoteTransportException.addSuppressed((Throwable)runtimeException);
        return remoteTransportException;
    }
}

