/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.runtime.testutils.recordutils.RecordComparator;
import org.apache.flink.runtime.util.NonReusingKeyGroupedIterator;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.IteratorAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class NonReusingKeyGroupedIteratorTest {
    private MutableObjectIterator<Record> sourceIter;
    private NonReusingKeyGroupedIterator<Record> psi;

    NonReusingKeyGroupedIteratorTest() {
    }

    @BeforeEach
    void setup() {
        final ArrayList<IntStringPair> source = new ArrayList<IntStringPair>();
        source.add(new IntStringPair(new IntValue(1), new StringValue((CharSequence)"A")));
        source.add(new IntStringPair(new IntValue(2), new StringValue((CharSequence)"B")));
        source.add(new IntStringPair(new IntValue(3), new StringValue((CharSequence)"C")));
        source.add(new IntStringPair(new IntValue(3), new StringValue((CharSequence)"D")));
        source.add(new IntStringPair(new IntValue(4), new StringValue((CharSequence)"E")));
        source.add(new IntStringPair(new IntValue(4), new StringValue((CharSequence)"F")));
        source.add(new IntStringPair(new IntValue(4), new StringValue((CharSequence)"G")));
        source.add(new IntStringPair(new IntValue(5), new StringValue((CharSequence)"H")));
        source.add(new IntStringPair(new IntValue(5), new StringValue((CharSequence)"I")));
        source.add(new IntStringPair(new IntValue(5), new StringValue((CharSequence)"J")));
        source.add(new IntStringPair(new IntValue(5), new StringValue((CharSequence)"K")));
        source.add(new IntStringPair(new IntValue(5), new StringValue((CharSequence)"L")));
        this.sourceIter = new MutableObjectIterator<Record>(){
            final Iterator<IntStringPair> it;
            {
                this.it = source.iterator();
            }

            public Record next(Record reuse) throws IOException {
                if (this.it.hasNext()) {
                    IntStringPair pair = this.it.next();
                    reuse.setField(0, (Value)pair.getInteger());
                    reuse.setField(1, (Value)pair.getString());
                    return reuse;
                }
                return null;
            }

            public Record next() throws IOException {
                if (this.it.hasNext()) {
                    IntStringPair pair = this.it.next();
                    Record result = new Record(2);
                    result.setField(0, (Value)pair.getInteger());
                    result.setField(1, (Value)pair.getString());
                    return result;
                }
                return null;
            }
        };
        RecordComparator comparator = new RecordComparator(new int[]{0}, new Class[]{IntValue.class});
        this.psi = new NonReusingKeyGroupedIterator(this.sourceIter, (TypeComparator)comparator);
    }

    @Test
    void testNextKeyOnly() throws Exception {
        try {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(1)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isOne();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(2)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(3)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(4)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(4);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(5);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must not have another key.", new Object[0])).isFalse();
            ((IterableAssert)Assertions.assertThat((Iterable)this.psi.getValues()).withFailMessage("KeyGroupedIterator must not have another value.", new Object[0])).isNull();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must not have another key.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must not have another key.", new Object[0])).isFalse();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"The test encountered an unexpected exception.");
        }
    }

    @Test
    void testFullIterationThroughAllValues() throws IOException {
        try {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(1)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isOne();
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("A");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must not have another value.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(1)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(2)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(2);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("B");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must not have another value.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(2)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(3)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("C");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(3)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("D");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(3)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.psi.getValues().next()).withFailMessage("A new KeyGroupedIterator must not have any value available and hence throw an exception on next().", new Object[0])).isInstanceOf(NoSuchElementException.class);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must not have another value.", new Object[0])).isFalse();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.psi.getValues().next()).withFailMessage("A new KeyGroupedIterator must not have any value available and hence throw an exception on next().", new Object[0])).isInstanceOf(NoSuchElementException.class);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(3)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(4)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(4);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("E");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(4)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(4);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("F");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(4)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(4);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("G");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(4)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(4);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must not have another value.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(4)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(4);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(5);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("H");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(5);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("I");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(5);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("J");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(5);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("K");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(5);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("L");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(5);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.psi.getValues().next()).withFailMessage("A new KeyGroupedIterator must not have any value available and hence throw an exception on next().", new Object[0])).isInstanceOf(NoSuchElementException.class);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must not have another value.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getComparatorWithCurrentReference().equalToReference((Object)new Record((Value)new IntValue(5)))).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(5);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.psi.getValues().next()).withFailMessage("A new KeyGroupedIterator must not have any value available and hence throw an exception on next().", new Object[0])).isInstanceOf(NoSuchElementException.class);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must not have another value.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must not have another value.", new Object[0])).isFalse();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"The test encountered an unexpected exception.");
        }
    }

    @Test
    void testMixedProgress() throws Exception {
        try {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("C");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("E");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("H");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(5);
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)((Record)this.psi.getCurrent()).getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(5);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)((Record)this.psi.getValues().next()).getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("I");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.getValues().hasNext()).withFailMessage("KeyGroupedIterator must have another value.", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must not have another key.", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must not have another key.", new Object[0])).isFalse();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"The test encountered an unexpected exception.");
        }
    }

    @Test
    void testHasNextDoesNotOverwriteCurrentRecord() throws Exception {
        try {
            NonReusingKeyGroupedIterator.ValuesIterator valsIter = null;
            Record rec = null;
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            valsIter = this.psi.getValues();
            ((IteratorAssert)Assertions.assertThat((Iterator)valsIter).withFailMessage("Returned Iterator must not be null", new Object[0])).isNotNull();
            ((IteratorAssert)Assertions.assertThat((Iterator)valsIter).withFailMessage("KeyGroupedIterator's value iterator must have another value.", new Object[0])).hasNext();
            rec = (Record)valsIter.next();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)rec.getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isOne();
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)rec.getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("A");
            ((IteratorAssert)Assertions.assertThat((Iterator)valsIter).withFailMessage("KeyGroupedIterator must not have another value.", new Object[0])).isExhausted();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)rec.getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isOne();
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)rec.getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("A");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            valsIter = this.psi.getValues();
            ((IteratorAssert)Assertions.assertThat((Iterator)valsIter).withFailMessage("Returned Iterator must not be null", new Object[0])).isNotNull();
            ((IteratorAssert)Assertions.assertThat((Iterator)valsIter).withFailMessage("KeyGroupedIterator's value iterator must have another value.", new Object[0])).hasNext();
            rec = (Record)valsIter.next();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)rec.getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(2);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)rec.getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("B");
            ((IteratorAssert)Assertions.assertThat((Iterator)valsIter).withFailMessage("KeyGroupedIterator must not have another value.", new Object[0])).isExhausted();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)rec.getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(2);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)rec.getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("B");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.psi.nextKey()).withFailMessage("KeyGroupedIterator must have another key.", new Object[0])).isTrue();
            valsIter = this.psi.getValues();
            ((IteratorAssert)Assertions.assertThat((Iterator)valsIter).withFailMessage("Returned Iterator must not be null", new Object[0])).isNotNull();
            ((IteratorAssert)Assertions.assertThat((Iterator)valsIter).withFailMessage("KeyGroupedIterator's value iterator must have another value.", new Object[0])).hasNext();
            rec = (Record)valsIter.next();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)rec.getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)rec.getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("C");
            ((IteratorAssert)Assertions.assertThat((Iterator)valsIter).withFailMessage("KeyGroupedIterator's value iterator must have another value.", new Object[0])).hasNext();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)rec.getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)rec.getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("C");
            rec = (Record)valsIter.next();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)rec.getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)rec.getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("D");
            ((IteratorAssert)Assertions.assertThat((Iterator)valsIter).withFailMessage("KeyGroupedIterator must not have another value.", new Object[0])).isExhausted();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)rec.getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)rec.getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("D");
            ((IteratorAssert)Assertions.assertThat((Iterator)valsIter).withFailMessage("KeyGroupedIterator must not have another value.", new Object[0])).isExhausted();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)rec.getField(0, IntValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong key.", new Object[0])).isEqualTo(3);
            ((AbstractStringAssert)Assertions.assertThat((String)((StringValue)rec.getField(1, StringValue.class)).getValue()).withFailMessage("KeyGroupedIterator returned a wrong value.", new Object[0])).isEqualTo("D");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"The test encountered an unexpected exception.");
        }
    }

    private static final class IntStringPair {
        private final IntValue integer;
        private final StringValue string;

        IntStringPair(IntValue integer, StringValue string) {
            this.integer = integer;
            this.string = string;
        }

        public IntValue getInteger() {
            return this.integer;
        }

        public StringValue getString() {
            return this.string;
        }
    }
}

