/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.UnknownShuffleDescriptor;
import org.apache.flink.runtime.util.DefaultGroupCache;
import org.apache.flink.shaded.guava33.com.google.common.base.Ticker;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultGroupCacheTest {
    private final Duration expireTimeout = Duration.ofSeconds(10L);

    DefaultGroupCacheTest() {
    }

    @Test
    void testGetEntry() {
        DefaultGroupCache cache = new DefaultGroupCache.Factory(this.expireTimeout, Integer.MAX_VALUE, Ticker.systemTicker()).create();
        JobID jobId = new JobID();
        UnknownShuffleDescriptor shuffleDescriptor = new UnknownShuffleDescriptor(new ResultPartitionID());
        TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup shuffleDescriptorGroup = new TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]{new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex((ShuffleDescriptor)shuffleDescriptor, 0)});
        PermanentBlobKey blobKey = new PermanentBlobKey();
        Assertions.assertThat((Object)((TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)cache.get((Object)jobId, (Object)blobKey))).isNull();
        cache.put((Object)jobId, (Object)blobKey, (Object)shuffleDescriptorGroup);
        Assertions.assertThat((Object)((TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)cache.get((Object)jobId, (Object)blobKey))).isEqualTo((Object)shuffleDescriptorGroup);
    }

    @Test
    void testClearCacheForJob() {
        DefaultGroupCache cache = new DefaultGroupCache.Factory(this.expireTimeout, Integer.MAX_VALUE, Ticker.systemTicker()).create();
        JobID jobId = new JobID();
        UnknownShuffleDescriptor shuffleDescriptor = new UnknownShuffleDescriptor(new ResultPartitionID());
        TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup shuffleDescriptorGroup = new TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]{new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex((ShuffleDescriptor)shuffleDescriptor, 0)});
        PermanentBlobKey blobKey = new PermanentBlobKey();
        Assertions.assertThat((Object)((TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)cache.get((Object)jobId, (Object)blobKey))).isNull();
        cache.put((Object)jobId, (Object)blobKey, (Object)shuffleDescriptorGroup);
        Assertions.assertThat((Object)((TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)cache.get((Object)jobId, (Object)blobKey))).isEqualTo((Object)shuffleDescriptorGroup);
        cache.clearCacheForGroup((Object)jobId);
        Assertions.assertThat((Object)((TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)cache.get((Object)jobId, (Object)blobKey))).isNull();
    }

    @Test
    void testPutWhenOverLimit() {
        DefaultGroupCache cache = new DefaultGroupCache.Factory(this.expireTimeout, 1, Ticker.systemTicker()).create();
        JobID jobId = new JobID();
        UnknownShuffleDescriptor shuffleDescriptor = new UnknownShuffleDescriptor(new ResultPartitionID());
        TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup shuffleDescriptorGroup = new TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]{new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex((ShuffleDescriptor)shuffleDescriptor, 0)});
        PermanentBlobKey blobKey = new PermanentBlobKey();
        cache.put((Object)jobId, (Object)blobKey, (Object)shuffleDescriptorGroup);
        Assertions.assertThat((Object)((TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)cache.get((Object)jobId, (Object)blobKey))).isEqualTo((Object)shuffleDescriptorGroup);
        TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup otherShuffleDescriptorGroup = new TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]{new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex((ShuffleDescriptor)new UnknownShuffleDescriptor(new ResultPartitionID()), 0)});
        PermanentBlobKey otherBlobKey = new PermanentBlobKey();
        cache.put((Object)jobId, (Object)otherBlobKey, (Object)otherShuffleDescriptorGroup);
        Assertions.assertThat((Object)((TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)cache.get((Object)jobId, (Object)blobKey))).isNull();
        Assertions.assertThat((Object)((TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)cache.get((Object)jobId, (Object)otherBlobKey))).isEqualTo((Object)otherShuffleDescriptorGroup);
    }

    @Test
    void testEntryExpired() {
        TestingTicker ticker = new TestingTicker();
        DefaultGroupCache cache = new DefaultGroupCache.Factory(Duration.ofSeconds(1L), Integer.MAX_VALUE, (Ticker)ticker).create();
        JobID jobId = new JobID();
        UnknownShuffleDescriptor shuffleDescriptor = new UnknownShuffleDescriptor(new ResultPartitionID());
        TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup shuffleDescriptorGroup = new TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]{new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex((ShuffleDescriptor)shuffleDescriptor, 0)});
        PermanentBlobKey blobKey = new PermanentBlobKey();
        cache.put((Object)jobId, (Object)blobKey, (Object)shuffleDescriptorGroup);
        Assertions.assertThat((Object)((TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)cache.get((Object)jobId, (Object)blobKey))).isEqualTo((Object)shuffleDescriptorGroup);
        ticker.advance(Duration.ofSeconds(2L));
        Assertions.assertThat((Object)((TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)cache.get((Object)jobId, (Object)blobKey))).isNull();
    }

    private static class TestingTicker
    extends Ticker {
        private final AtomicLong nanos = new AtomicLong();

        private TestingTicker() {
        }

        public void advance(Duration duration) {
            this.nanos.addAndGet(duration.toNanos());
        }

        public long read() {
            return this.nanos.get();
        }
    }
}

