/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.runtime.state.ttl.TtlListStateTestContextBase;

public class TtlListStateWithKryoTestContext
extends TtlListStateTestContextBase<NotPojoElement> {
    TtlListStateWithKryoTestContext() {
        super(new KryoSerializer(NotPojoElement.class, TtlListStateWithKryoTestContext.getForceKryoSerializerConfig()));
    }

    private static SerializerConfig getForceKryoSerializerConfig() {
        Configuration config = new Configuration();
        config.set(PipelineOptions.FORCE_KRYO, (Object)true);
        return new SerializerConfigImpl(config);
    }

    @Override
    NotPojoElement generateRandomElement(int i) {
        return new NotPojoElement(RANDOM.nextInt(100));
    }

    @Override
    void initTestValues() {
        this.emptyValue = Collections.emptyList();
        this.updateEmpty = Arrays.asList(new NotPojoElement(5), new NotPojoElement(7), new NotPojoElement(10));
        this.updateUnexpired = Arrays.asList(new NotPojoElement(8), new NotPojoElement(9), new NotPojoElement(11));
        this.updateExpired = Arrays.asList(new NotPojoElement(1), new NotPojoElement(4));
        this.getUpdateEmpty = this.updateEmpty;
        this.getUnexpired = this.updateUnexpired;
        this.getUpdateExpired = this.updateExpired;
    }

    public static class NotPojoElement {
        public int value;

        public NotPojoElement(int value) {
            this.value = value;
        }

        public String toString() {
            return "NotPojoElement{value=" + this.value + "}";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NotPojoElement that = (NotPojoElement)obj;
            return this.value == that.value;
        }

        public int hashCode() {
            return Integer.hashCode(this.value);
        }
    }
}

