/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.checkpoint.StateHandleDummyUtil;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointTestUtils;
import org.apache.flink.runtime.state.IncrementalRemoteKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.TestStreamStateHandle;
import org.apache.flink.runtime.state.changelog.ChangelogStateBackendHandle;
import org.apache.flink.runtime.state.changelog.SequenceNumber;
import org.apache.flink.runtime.state.changelog.inmemory.InMemoryChangelogStateHandle;

public class ChangelogTestUtils {
    public static ChangelogStateBackendHandle createChangelogStateBackendHandle() {
        return ChangelogTestUtils.createChangelogStateBackendHandle(StateHandleDummyUtil.createNewKeyedStateHandle(new KeyGroupRange(0, 1)));
    }

    public static ChangelogStateBackendHandle createChangelogStateBackendHandle(KeyedStateHandle keyedStateHandle) {
        return new ChangelogStateBackendHandle.ChangelogStateBackendHandleImpl(Collections.singletonList(keyedStateHandle), Collections.emptyList(), new KeyGroupRange(0, 1), 1L, 1L, 0L);
    }

    public static IncrementalStateHandleWrapper createDummyIncrementalStateHandle(long checkpointId) {
        return new IncrementalStateHandleWrapper(CheckpointTestUtils.createDummyIncrementalKeyedStateHandle(checkpointId, ThreadLocalRandom.current()));
    }

    public static ChangelogStateHandleWrapper createDummyChangelogStateHandle(long from, long to) {
        return new ChangelogStateHandleWrapper(new InMemoryChangelogStateHandle(Collections.emptyList(), SequenceNumber.of((long)from), SequenceNumber.of((long)to), new KeyGroupRange(1, 1)));
    }

    public static class ChangelogStateHandleWrapper
    extends InMemoryChangelogStateHandle
    implements TestStreamStateHandle {
        private static final long serialVersionUID = 1L;
        private volatile boolean isDiscarded;

        public ChangelogStateHandleWrapper(InMemoryChangelogStateHandle stateHandle) {
            super(stateHandle.getChanges(), SequenceNumber.of((long)stateHandle.getFrom()), SequenceNumber.of((long)stateHandle.getTo()), stateHandle.getKeyGroupRange());
        }

        public void registerSharedStates(SharedStateRegistry stateRegistry, long checkpointID) {
            stateRegistry.registerReference(this.getSharedStateRegistryKey(), (StreamStateHandle)this, checkpointID);
        }

        private SharedStateRegistryKey getSharedStateRegistryKey() {
            return new SharedStateRegistryKey(String.valueOf(this.getKeyGroupRange()) + "_" + this.getFrom() + "_" + this.getTo());
        }

        public void discardState() {
            super.discardState();
            this.isDiscarded = true;
        }

        public FSDataInputStream openInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Optional<byte[]> asBytesIfInMemory() {
            throw new UnsupportedOperationException();
        }

        boolean isDiscarded() {
            return this.isDiscarded;
        }
    }

    public static class IncrementalStateHandleWrapper
    extends IncrementalRemoteKeyedStateHandle {
        private static final long serialVersionUID = 1L;
        private final IncrementalRemoteKeyedStateHandle stateHandle;
        private volatile boolean isDiscarded;

        IncrementalStateHandleWrapper(IncrementalRemoteKeyedStateHandle stateHandle) {
            super(stateHandle.getBackendIdentifier(), stateHandle.getKeyGroupRange(), stateHandle.getCheckpointId(), stateHandle.getSharedState(), stateHandle.getPrivateState(), stateHandle.getMetaDataStateHandle(), stateHandle.getCheckpointedSize(), stateHandle.getStateHandleId());
            this.stateHandle = stateHandle;
        }

        public void discardState() throws Exception {
            super.discardState();
            this.isDiscarded = true;
        }

        boolean isDiscarded() {
            return this.isDiscarded;
        }

        IncrementalStateHandleWrapper deserialize() {
            return new IncrementalStateHandleWrapper(this.stateHandle.copy());
        }

        public boolean equals(Object o) {
            return this == o;
        }
    }
}

