/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobInformation;

public class TestJobInformation
implements JobInformation {
    private final Map<JobVertexID, JobInformation.VertexInformation> vertexIdToInformation;
    private final Set<SlotSharingGroup> slotSharingGroups;
    private final Set<CoLocationGroup> coLocationGroups;

    public TestJobInformation(Collection<? extends JobInformation.VertexInformation> vertexIdToInformation) {
        this.vertexIdToInformation = vertexIdToInformation.stream().collect(Collectors.toMap(JobInformation.VertexInformation::getJobVertexID, Function.identity()));
        this.slotSharingGroups = vertexIdToInformation.stream().map(JobInformation.VertexInformation::getSlotSharingGroup).collect(Collectors.toSet());
        this.coLocationGroups = Collections.unmodifiableSet(vertexIdToInformation.stream().map(JobInformation.VertexInformation::getCoLocationGroup).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public Collection<SlotSharingGroup> getSlotSharingGroups() {
        return this.slotSharingGroups;
    }

    public Collection<CoLocationGroup> getCoLocationGroups() {
        return this.coLocationGroups;
    }

    public JobInformation.VertexInformation getVertexInformation(JobVertexID jobVertexId) {
        return this.vertexIdToInformation.get(jobVertexId);
    }

    public Iterable<JobInformation.VertexInformation> getVertices() {
        return this.vertexIdToInformation.values();
    }
}

