/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.failure.FailureEnricherUtils;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.scheduler.adaptive.Finished;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FinishedTest {
    private static final Logger log = LoggerFactory.getLogger(FinishedTest.class);
    private final JobStatus testJobStatus = JobStatus.FAILED;

    FinishedTest() {
    }

    @Test
    void testOnFinishedCallOnEnter() {
        MockFinishedContext ctx = new MockFinishedContext();
        this.createFinishedState(ctx);
        Assertions.assertThat((Comparable)ctx.getArchivedExecutionGraph().getState()).isEqualTo((Object)this.testJobStatus);
    }

    @Test
    void testCancelIgnored() {
        MockFinishedContext ctx = new MockFinishedContext();
        this.createFinishedState(ctx).cancel();
        Assertions.assertThat((Comparable)ctx.getArchivedExecutionGraph().getState()).isEqualTo((Object)this.testJobStatus);
    }

    @Test
    void testSuspendIgnored() {
        MockFinishedContext ctx = new MockFinishedContext();
        this.createFinishedState(ctx).suspend((Throwable)new RuntimeException());
        Assertions.assertThat((Comparable)ctx.getArchivedExecutionGraph().getState()).isEqualTo((Object)this.testJobStatus);
    }

    @Test
    void testGlobalFailureIgnored() {
        MockFinishedContext ctx = new MockFinishedContext();
        this.createFinishedState(ctx).handleGlobalFailure((Throwable)new RuntimeException(), FailureEnricherUtils.EMPTY_FAILURE_LABELS);
        Assertions.assertThat((Comparable)ctx.getArchivedExecutionGraph().getState()).isEqualTo((Object)this.testJobStatus);
    }

    @Test
    void testGetJobStatus() {
        MockFinishedContext ctx = new MockFinishedContext();
        Assertions.assertThat((Comparable)this.createFinishedState(ctx).getJobStatus()).isEqualTo((Object)this.testJobStatus);
    }

    private Finished createFinishedState(MockFinishedContext ctx) {
        ArchivedExecutionGraph archivedExecutionGraph = new ArchivedExecutionGraphBuilder().setState(this.testJobStatus).build();
        return new Finished((Finished.Context)ctx, archivedExecutionGraph, log);
    }

    private static class MockFinishedContext
    implements Finished.Context {
        private ArchivedExecutionGraph archivedExecutionGraph = null;

        private MockFinishedContext() {
        }

        public void onFinished(ArchivedExecutionGraph archivedExecutionGraph) {
            if (archivedExecutionGraph == null) {
                throw new AssertionError((Object)"Transitioned to onFinished twice");
            }
            this.archivedExecutionGraph = archivedExecutionGraph;
        }

        private ArchivedExecutionGraph getArchivedExecutionGraph() {
            return this.archivedExecutionGraph;
        }
    }
}

