/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.json;

import org.apache.flink.runtime.rest.messages.json.SerializedThrowableDeserializer;
import org.apache.flink.runtime.rest.messages.json.SerializedThrowableSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SerializedThrowableSerializerTest {
    private ObjectMapper objectMapper;

    SerializedThrowableSerializerTest() {
    }

    @BeforeEach
    void setUp() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(SerializedThrowable.class, (JsonDeserializer)new SerializedThrowableDeserializer());
        simpleModule.addSerializer(SerializedThrowable.class, (JsonSerializer)new SerializedThrowableSerializer());
        this.objectMapper = JacksonMapperFactory.createObjectMapper();
        this.objectMapper.registerModule((Module)simpleModule);
    }

    @Test
    void testSerializationDeserialization() throws Exception {
        Exception cause = new Exception("cause");
        Exception root = new Exception("message", cause);
        Exception suppressed = new Exception("suppressed");
        root.addSuppressed(suppressed);
        SerializedThrowable serializedThrowable = new SerializedThrowable((Throwable)root);
        String json = this.objectMapper.writeValueAsString((Object)serializedThrowable);
        SerializedThrowable deserializedSerializedThrowable = (SerializedThrowable)this.objectMapper.readValue(json, SerializedThrowable.class);
        Assertions.assertThat((String)deserializedSerializedThrowable.getMessage()).isEqualTo("java.lang.Exception: message");
        Assertions.assertThat((String)serializedThrowable.getFullStringifiedStackTrace()).isEqualTo(deserializedSerializedThrowable.getFullStringifiedStackTrace());
        Assertions.assertThat((String)deserializedSerializedThrowable.getCause().getMessage()).isEqualTo("java.lang.Exception: cause");
        Assertions.assertThat((Throwable)deserializedSerializedThrowable.getCause()).isInstanceOf(SerializedThrowable.class);
        Assertions.assertThat((int)deserializedSerializedThrowable.getSuppressed().length).isOne();
        Assertions.assertThat((String)deserializedSerializedThrowable.getSuppressed()[0].getMessage()).isEqualTo("java.lang.Exception: suppressed");
        Assertions.assertThat((Throwable)deserializedSerializedThrowable.getSuppressed()[0]).isInstanceOf(SerializedThrowable.class);
    }
}

