/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.messages.FlinkJobTerminatedWithoutCancellationException;
import org.apache.flink.runtime.rest.RestMatchers;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.JobCancellationHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.JobCancellationHeaders;
import org.apache.flink.runtime.rest.messages.JobCancellationMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.TerminationModeQueryParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.ThrowingConsumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.junit.jupiter.api.Test;

class JobCancellationHandlerTest {
    JobCancellationHandlerTest() {
    }

    @Test
    void testSuccessfulCancellation() throws Exception {
        JobCancellationHandlerTest.testResponse(jobId -> CompletableFuture.completedFuture(Acknowledge.get()), (ThrowingConsumer<CompletableFuture<EmptyResponseBody>, Exception>)((ThrowingConsumer)CompletableFuture::get));
    }

    @Test
    void testErrorCodeForNonCanceledTerminalJob() throws Exception {
        JobCancellationHandlerTest.testResponseCodeOnFailedDispatcherCancellationResponse(jobId -> FutureUtils.completedExceptionally((Throwable)new FlinkJobTerminatedWithoutCancellationException(jobId, JobStatus.FINISHED)), HttpResponseStatus.CONFLICT);
    }

    @Test
    void testErrorCodeForTimeout() throws Exception {
        JobCancellationHandlerTest.testResponseCodeOnFailedDispatcherCancellationResponse(jobId -> FutureUtils.completedExceptionally((Throwable)new TimeoutException()), HttpResponseStatus.REQUEST_TIMEOUT);
    }

    @Test
    void testErrorCodeForUnknownJob() throws Exception {
        JobCancellationHandlerTest.testResponseCodeOnFailedDispatcherCancellationResponse(jobId -> FutureUtils.completedExceptionally((Throwable)new FlinkJobNotFoundException(jobId)), HttpResponseStatus.NOT_FOUND);
    }

    @Test
    void testErrorCodeForUnknownError() throws Exception {
        JobCancellationHandlerTest.testResponseCodeOnFailedDispatcherCancellationResponse(jobId -> FutureUtils.completedExceptionally((Throwable)new RuntimeException()), HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    private static void testResponseCodeOnFailedDispatcherCancellationResponse(Function<JobID, CompletableFuture<Acknowledge>> cancelJobFunction, HttpResponseStatus expectedErrorCode) throws Exception {
        JobCancellationHandlerTest.testResponse(cancelJobFunction, (ThrowingConsumer<CompletableFuture<EmptyResponseBody>, Exception>)((ThrowingConsumer)cancellationFuture -> Assertions.assertThat((CompletableFuture)cancellationFuture).satisfies((Condition)HamcrestCondition.matching(RestMatchers.respondsWithError(expectedErrorCode)))));
    }

    private static void testResponse(Function<JobID, CompletableFuture<Acknowledge>> cancelJobFunction, ThrowingConsumer<CompletableFuture<EmptyResponseBody>, Exception> assertion) throws Exception {
        RestfulGateway gateway = JobCancellationHandlerTest.createGateway(cancelJobFunction);
        JobCancellationHandler jobCancellationHandler = JobCancellationHandlerTest.createHandler(gateway);
        JobCancellationMessageParameters messageParameters = ((JobCancellationMessageParameters)jobCancellationHandler.getMessageHeaders().getUnresolvedMessageParameters()).resolveJobId(new JobID());
        CompletableFuture cancellationFuture = jobCancellationHandler.handleRequest(HandlerRequest.create((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)messageParameters), gateway);
        assertion.accept((Object)cancellationFuture);
    }

    private static RestfulGateway createGateway(Function<JobID, CompletableFuture<Acknowledge>> cancelJobFunction) {
        return ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setCancelJobFunction((Function)cancelJobFunction)).build();
    }

    private static JobCancellationHandler createHandler(RestfulGateway gateway) {
        return new JobCancellationHandler(() -> CompletableFuture.completedFuture(gateway), Duration.ofHours(1L), Collections.emptyMap(), (MessageHeaders)JobCancellationHeaders.getInstance(), TerminationModeQueryParameter.TerminationMode.CANCEL);
    }
}

