/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.runtime.blocklist.BlocklistHandler;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTrackerFactory;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.runtime.resourcemanager.slotmanager.NonSupportedResourceAllocatorImpl;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocator;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.security.token.DelegationTokenManager;

public class TestingResourceManager
extends ResourceManager<ResourceID> {
    private final Consumer<ResourceID> stopWorkerConsumer;
    private final CompletableFuture<Void> readyToServeFuture;

    public TestingResourceManager(RpcService rpcService, UUID leaderSessionId, ResourceID resourceId, HeartbeatServices heartbeatServices, DelegationTokenManager delegationTokenManager, SlotManager slotManager, ResourceManagerPartitionTrackerFactory clusterPartitionTrackerFactory, BlocklistHandler.Factory blocklistHandlerFactory, JobLeaderIdService jobLeaderIdService, FatalErrorHandler fatalErrorHandler, ResourceManagerMetricGroup resourceManagerMetricGroup, Consumer<ResourceID> stopWorkerConsumer, CompletableFuture<Void> readyToServeFuture) {
        super(rpcService, leaderSessionId, resourceId, heartbeatServices, delegationTokenManager, slotManager, clusterPartitionTrackerFactory, blocklistHandlerFactory, jobLeaderIdService, new ClusterInformation("localhost", 1234), fatalErrorHandler, resourceManagerMetricGroup, RpcUtils.INF_TIMEOUT, (Executor)ForkJoinPool.commonPool());
        this.stopWorkerConsumer = stopWorkerConsumer;
        this.readyToServeFuture = readyToServeFuture;
    }

    protected void initialize() throws ResourceManagerException {
    }

    protected void terminate() {
    }

    protected void internalDeregisterApplication(ApplicationStatus finalStatus, @Nullable String diagnostics) throws ResourceManagerException {
    }

    protected Optional<ResourceID> getWorkerNodeIfAcceptRegistration(ResourceID resourceID) {
        return Optional.of(resourceID);
    }

    public void stopWorkerIfSupported(ResourceID worker) {
        this.stopWorkerConsumer.accept(worker);
    }

    public CompletableFuture<Void> getReadyToServeFuture() {
        return this.readyToServeFuture;
    }

    protected ResourceAllocator getResourceAllocator() {
        return NonSupportedResourceAllocatorImpl.INSTANCE;
    }

    public <T> CompletableFuture<T> runInMainThread(Callable<T> callable, Duration timeout) {
        return this.callAsync(callable, timeout);
    }
}

