/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PendingRequest;
import org.apache.flink.runtime.jobmaster.slotpool.PreferredAllocationRequestSlotMatchingStrategyTest;
import org.apache.flink.runtime.jobmaster.slotpool.TasksBalancedRequestSlotMatchingStrategy;
import org.apache.flink.runtime.scheduler.TestingPhysicalSlot;
import org.apache.flink.runtime.scheduler.loading.DefaultLoadingWeight;
import org.apache.flink.runtime.scheduler.loading.LoadingWeight;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TasksBalancedRequestSlotMatchingStrategyTest {
    private static final ResourceProfile smallFineGrainedProfile = ResourceProfile.newBuilder().setCpuCores(1.0).build();
    private static final ResourceProfile bigFineGrainedProfile = ResourceProfile.newBuilder().setCpuCores(2.0).build();
    private static final TaskManagerLocation tmLocation1 = new LocalTaskManagerLocation();
    private static final TaskManagerLocation tmLocation2 = new LocalTaskManagerLocation();

    TasksBalancedRequestSlotMatchingStrategyTest() {
    }

    @Test
    void testMatchRequestsAndSlotsRiskOfFineGrainedResourcesMatchedToUnknownProfile() {
        List<PendingRequest> pendingRequests = Arrays.asList(TasksBalancedRequestSlotMatchingStrategyTest.createRequest(ResourceProfile.UNKNOWN, 100.0f), TasksBalancedRequestSlotMatchingStrategyTest.createRequest(bigFineGrainedProfile, 1.0f));
        List<TestingPhysicalSlot> slots = Arrays.asList(PreferredAllocationRequestSlotMatchingStrategyTest.createSlot(bigFineGrainedProfile, new AllocationID(), tmLocation1), PreferredAllocationRequestSlotMatchingStrategyTest.createSlot(smallFineGrainedProfile, new AllocationID(), tmLocation2));
        Collection requestSlotMatches = TasksBalancedRequestSlotMatchingStrategy.INSTANCE.matchRequestsAndSlots(slots, pendingRequests, (Map)new HashMap<ResourceID, LoadingWeight>(){
            {
                this.put(tmLocation1.getResourceID(), DefaultLoadingWeight.EMPTY);
                this.put(tmLocation2.getResourceID(), new DefaultLoadingWeight(9.0f));
            }
        });
        Assertions.assertThat((Collection)requestSlotMatches).hasSize(2);
    }

    @Test
    void testMatchRequestsAndSlotsMissingFineGrainedResources() {
        PendingRequest requestWithBigProfile = TasksBalancedRequestSlotMatchingStrategyTest.createRequest(bigFineGrainedProfile, 6.0f);
        PendingRequest requestWithUnknownProfile = TasksBalancedRequestSlotMatchingStrategyTest.createRequest(ResourceProfile.UNKNOWN, 6.0f);
        PendingRequest requestWithSmallProfile = TasksBalancedRequestSlotMatchingStrategyTest.createRequest(smallFineGrainedProfile, 6.0f);
        List<PendingRequest> pendingRequests = Arrays.asList(requestWithSmallProfile, requestWithUnknownProfile, requestWithBigProfile);
        List<TestingPhysicalSlot> slots = Arrays.asList(PreferredAllocationRequestSlotMatchingStrategyTest.createSlot(bigFineGrainedProfile, new AllocationID(), new LocalTaskManagerLocation()), PreferredAllocationRequestSlotMatchingStrategyTest.createSlot(bigFineGrainedProfile, new AllocationID(), new LocalTaskManagerLocation()), PreferredAllocationRequestSlotMatchingStrategyTest.createSlot(bigFineGrainedProfile, new AllocationID(), new LocalTaskManagerLocation()));
        Collection requestSlotMatches = TasksBalancedRequestSlotMatchingStrategy.INSTANCE.matchRequestsAndSlots(slots, pendingRequests, new HashMap());
        Assertions.assertThat((Collection)requestSlotMatches).isEmpty();
    }

    private static PendingRequest createRequest(ResourceProfile requestProfile, float loading) {
        return PendingRequest.createNormalRequest((SlotRequestId)new SlotRequestId(), (ResourceProfile)requestProfile, (LoadingWeight)new DefaultLoadingWeight(loading), Collections.emptyList());
    }
}

