/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PendingRequest;
import org.apache.flink.runtime.jobmaster.slotpool.ResourceRequestPreMappings;
import org.apache.flink.runtime.scheduler.adaptive.allocator.TestingSlot;
import org.apache.flink.runtime.scheduler.loading.DefaultLoadingWeight;
import org.apache.flink.runtime.scheduler.loading.LoadingWeight;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;

class ResourceRequestPreMappingsTest {
    private static final ResourceProfile smallFineGrainedResourceProfile = ResourceProfile.newBuilder().setManagedMemoryMB(10).build();
    private static final ResourceProfile bigGrainedResourceProfile = ResourceProfile.newBuilder().setManagedMemoryMB(20).build();

    ResourceRequestPreMappingsTest() {
    }

    @Test
    void testIncludeInvalidProfileOfRequestOrResource() {
        ResourceProfile[] profiles;
        for (ResourceProfile profile : profiles = new ResourceProfile[]{ResourceProfile.UNKNOWN, ResourceProfile.ZERO}) {
            Assertions.assertThatThrownBy(() -> ResourceRequestPreMappings.createFrom(Collections.emptyList(), this.newTestingSlots(profile))).isInstanceOf(IllegalStateException.class);
        }
        for (ResourceProfile profile : profiles = new ResourceProfile[]{ResourceProfile.ANY, ResourceProfile.ZERO}) {
            Assertions.assertThatThrownBy(() -> ResourceRequestPreMappings.createFrom(this.newPendingRequests(profile), Collections.emptyList())).isInstanceOf(IllegalStateException.class);
        }
    }

    @Test
    void testBuildWhenUnavailableTotalResourcesOrEmptyRequestsResources() {
        ResourceRequestPreMappings preMappings = ResourceRequestPreMappings.createFrom(this.newPendingRequests(ResourceProfile.UNKNOWN), Collections.emptyList());
        Assertions.assertThat((boolean)preMappings.isMatchingFulfilled()).isFalse();
        Assertions.assertThat((Map)preMappings.getBaseRequiredResourcePreMappings()).isEmpty();
        preMappings = ResourceRequestPreMappings.createFrom(Collections.emptyList(), Collections.emptyList());
        this.assertNotMatchable(preMappings);
    }

    @Test
    void testBuildWhenMissingResourceToMatchFineGrainedRequest() {
        ResourceRequestPreMappings preMappings = ResourceRequestPreMappings.createFrom(this.newPendingRequests(smallFineGrainedResourceProfile, smallFineGrainedResourceProfile, bigGrainedResourceProfile), this.newTestingSlots(smallFineGrainedResourceProfile, smallFineGrainedResourceProfile, smallFineGrainedResourceProfile));
        this.assertNotMatchable(preMappings);
        preMappings = ResourceRequestPreMappings.createFrom(this.newPendingRequests(ResourceProfile.UNKNOWN, smallFineGrainedResourceProfile, bigGrainedResourceProfile), this.newTestingSlots(smallFineGrainedResourceProfile, smallFineGrainedResourceProfile, smallFineGrainedResourceProfile));
        this.assertNotMatchable(preMappings);
    }

    @Test
    void testBuildSuccessfullyThatFinedGrainedMatchedExactly() {
        ResourceRequestPreMappings preMappings = ResourceRequestPreMappings.createFrom(this.newPendingRequests(smallFineGrainedResourceProfile, smallFineGrainedResourceProfile, bigGrainedResourceProfile), this.newTestingSlots(bigGrainedResourceProfile, smallFineGrainedResourceProfile, smallFineGrainedResourceProfile, smallFineGrainedResourceProfile));
        Assertions.assertThat((boolean)preMappings.isMatchingFulfilled()).isTrue();
        ((MapAssert)Assertions.assertThat((Map)preMappings.getBaseRequiredResourcePreMappings()).hasSize(2)).contains(new Map.Entry[]{new AbstractMap.SimpleEntry<ResourceProfile, 1>(smallFineGrainedResourceProfile, new HashMap<ResourceProfile, Integer>(){
            {
                this.put(smallFineGrainedResourceProfile, 2);
            }
        }), new AbstractMap.SimpleEntry<ResourceProfile, 2>(bigGrainedResourceProfile, new HashMap<ResourceProfile, Integer>(){
            {
                this.put(bigGrainedResourceProfile, 1);
            }
        })});
        Assertions.assertThat((Map)preMappings.getRemainingFlexibleResources()).contains(new Map.Entry[]{new AbstractMap.SimpleEntry<ResourceProfile, Integer>(smallFineGrainedResourceProfile, 1)});
    }

    @Test
    void testBuildSuccessfullyThatFinedGrainedToMatchedUnknownRequests() {
        ResourceRequestPreMappings preMappings = ResourceRequestPreMappings.createFrom(this.newPendingRequests(ResourceProfile.UNKNOWN, ResourceProfile.UNKNOWN, smallFineGrainedResourceProfile, bigGrainedResourceProfile), this.newTestingSlots(bigGrainedResourceProfile, bigGrainedResourceProfile, bigGrainedResourceProfile, ResourceProfile.ANY, smallFineGrainedResourceProfile, smallFineGrainedResourceProfile));
        Assertions.assertThat((boolean)preMappings.isMatchingFulfilled()).isTrue();
        ((MapAssert)Assertions.assertThat((Map)preMappings.getBaseRequiredResourcePreMappings()).hasSize(3)).contains(new Map.Entry[]{new AbstractMap.SimpleEntry<ResourceProfile, 3>(smallFineGrainedResourceProfile, new HashMap<ResourceProfile, Integer>(){
            {
                this.put(smallFineGrainedResourceProfile, 1);
            }
        }), new AbstractMap.SimpleEntry<ResourceProfile, 4>(bigGrainedResourceProfile, new HashMap<ResourceProfile, Integer>(){
            {
                this.put(bigGrainedResourceProfile, 1);
            }
        })});
        Map unknownBaseMapping = (Map)preMappings.getBaseRequiredResourcePreMappings().get(ResourceProfile.UNKNOWN);
        Assertions.assertThat((Integer)unknownBaseMapping.values().stream().reduce(0, Integer::sum)).isEqualTo(2);
        Assertions.assertThat((Integer)preMappings.getRemainingFlexibleResources().values().stream().reduce(0, Integer::sum)).isEqualTo(2);
    }

    @Test
    void testBuildSuccessfullyThatAnyToMatchedUnknownAndFineGrainedRequests() {
        ResourceRequestPreMappings preMappings = ResourceRequestPreMappings.createFrom(this.newPendingRequests(ResourceProfile.UNKNOWN, ResourceProfile.UNKNOWN, smallFineGrainedResourceProfile, smallFineGrainedResourceProfile, bigGrainedResourceProfile, bigGrainedResourceProfile), this.newTestingSlots(bigGrainedResourceProfile, smallFineGrainedResourceProfile, ResourceProfile.ANY, ResourceProfile.ANY, ResourceProfile.ANY, ResourceProfile.ANY));
        Assertions.assertThat((boolean)preMappings.isMatchingFulfilled()).isTrue();
        ((MapAssert)Assertions.assertThat((Map)preMappings.getBaseRequiredResourcePreMappings()).hasSize(3)).contains(new Map.Entry[]{new AbstractMap.SimpleEntry<ResourceProfile, 5>(smallFineGrainedResourceProfile, new HashMap<ResourceProfile, Integer>(){
            {
                this.put(smallFineGrainedResourceProfile, 1);
                this.put(ResourceProfile.ANY, 1);
            }
        }), new AbstractMap.SimpleEntry<ResourceProfile, 6>(bigGrainedResourceProfile, new HashMap<ResourceProfile, Integer>(){
            {
                this.put(bigGrainedResourceProfile, 1);
                this.put(ResourceProfile.ANY, 1);
            }
        }), new AbstractMap.SimpleEntry<ResourceProfile, 7>(ResourceProfile.UNKNOWN, new HashMap<ResourceProfile, Integer>(){
            {
                this.put(ResourceProfile.ANY, 2);
            }
        })});
        Assertions.assertThat((Integer)preMappings.getRemainingFlexibleResources().values().stream().reduce(0, Integer::sum)).isZero();
    }

    @Test
    void testHasAvailableProfile() {
        ResourceRequestPreMappings mappings = ResourceRequestPreMappings.createFrom(this.newPendingRequests(ResourceProfile.UNKNOWN, ResourceProfile.UNKNOWN), this.newTestingSlots(smallFineGrainedResourceProfile, smallFineGrainedResourceProfile, smallFineGrainedResourceProfile));
        Assertions.assertThat((boolean)mappings.hasAvailableProfile(smallFineGrainedResourceProfile, smallFineGrainedResourceProfile)).isTrue();
        Assertions.assertThat((boolean)mappings.hasAvailableProfile(smallFineGrainedResourceProfile, bigGrainedResourceProfile)).isFalse();
        Assertions.assertThat((boolean)mappings.hasAvailableProfile(ResourceProfile.UNKNOWN, smallFineGrainedResourceProfile)).isTrue();
        Assertions.assertThat((boolean)mappings.hasAvailableProfile(ResourceProfile.UNKNOWN, bigGrainedResourceProfile)).isFalse();
    }

    @Test
    void testDecrease() {
        ResourceRequestPreMappings mappings = ResourceRequestPreMappings.createFrom(this.newPendingRequests(ResourceProfile.UNKNOWN, ResourceProfile.UNKNOWN), this.newTestingSlots(smallFineGrainedResourceProfile, smallFineGrainedResourceProfile, smallFineGrainedResourceProfile));
        mappings.decrease(ResourceProfile.UNKNOWN, smallFineGrainedResourceProfile);
        Assertions.assertThat((int)mappings.getAvailableResourceCntOfBasePreMappings(ResourceProfile.UNKNOWN, smallFineGrainedResourceProfile)).isOne();
        Assertions.assertThatThrownBy(() -> mappings.decrease(smallFineGrainedResourceProfile, smallFineGrainedResourceProfile)).isInstanceOf(IllegalStateException.class);
        ResourceRequestPreMappings mappings2 = ResourceRequestPreMappings.createFrom((boolean)true, (Map)new HashMap<ResourceProfile, Map<ResourceProfile, Integer>>(){
            {
                this.put(ResourceProfile.UNKNOWN, new HashMap<ResourceProfile, Integer>(){
                    {
                        this.put(smallFineGrainedResourceProfile, 2);
                    }
                });
            }
        }, (Map)new HashMap<ResourceProfile, Integer>(){
            {
                this.put(smallFineGrainedResourceProfile, 1);
                this.put(bigGrainedResourceProfile, 2);
            }
        });
        mappings2.decrease(ResourceProfile.UNKNOWN, bigGrainedResourceProfile);
        Assertions.assertThat((int)mappings2.getAvailableResourceCntOfRemainingFlexibleMapping(bigGrainedResourceProfile)).isOne();
        Assertions.assertThat((int)mappings2.getAvailableResourceCntOfBasePreMappings(ResourceProfile.UNKNOWN, smallFineGrainedResourceProfile)).isOne();
        Assertions.assertThat((int)mappings2.getAvailableResourceCntOfRemainingFlexibleMapping(smallFineGrainedResourceProfile)).isEqualTo(2);
        mappings2.decrease(ResourceProfile.UNKNOWN, smallFineGrainedResourceProfile);
        Assertions.assertThatThrownBy(() -> mappings2.decrease(ResourceProfile.UNKNOWN, smallFineGrainedResourceProfile)).isInstanceOf(IllegalStateException.class);
    }

    private List<PendingRequest> newPendingRequests(ResourceProfile ... requiredProfiles) {
        ArrayList<PendingRequest> pendingRequests = new ArrayList<PendingRequest>();
        if (requiredProfiles == null || requiredProfiles.length == 0) {
            return pendingRequests;
        }
        for (ResourceProfile requiredProfile : requiredProfiles) {
            pendingRequests.add(PendingRequest.createNormalRequest((SlotRequestId)new SlotRequestId(), (ResourceProfile)((ResourceProfile)Preconditions.checkNotNull((Object)requiredProfile)), (LoadingWeight)DefaultLoadingWeight.EMPTY, Collections.emptyList()));
        }
        return pendingRequests;
    }

    private List<TestingSlot> newTestingSlots(ResourceProfile ... slotProfiles) {
        ArrayList<TestingSlot> slots = new ArrayList<TestingSlot>();
        if (slotProfiles == null || slotProfiles.length == 0) {
            return slots;
        }
        for (ResourceProfile slotProfile : slotProfiles) {
            slots.add(new TestingSlot((ResourceProfile)Preconditions.checkNotNull((Object)slotProfile)));
        }
        return slots;
    }

    private void assertNotMatchable(ResourceRequestPreMappings preMappings) {
        Assertions.assertThat((boolean)preMappings.isMatchingFulfilled()).isFalse();
        Assertions.assertThat((Map)preMappings.getBaseRequiredResourcePreMappings()).isEmpty();
    }
}

