/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridge;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultDeclarativeSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.RequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SimpleRequestSlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class DeclarativeSlotPoolBridgeBuilder {
    private JobID jobId = new JobID();
    private Duration batchSlotTimeout = (Duration)JobManagerOptions.SLOT_IDLE_TIMEOUT.defaultValue();
    private Duration idleSlotTimeout = TestingUtils.infiniteDuration();
    private Clock clock = SystemClock.getInstance();
    private Duration slotRequestMaxInterval = (Duration)JobManagerOptions.SLOT_REQUEST_MAX_INTERVAL.defaultValue();
    private ComponentMainThreadExecutor mainThreadExecutor = ComponentMainThreadExecutorServiceAdapter.forMainThread();
    private boolean deferSlotAllocation = false;
    @Nullable
    private ResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();
    private RequestSlotMatchingStrategy requestSlotMatchingStrategy = SimpleRequestSlotMatchingStrategy.INSTANCE;

    public DeclarativeSlotPoolBridgeBuilder setResourceManagerGateway(@Nullable ResourceManagerGateway resourceManagerGateway) {
        this.resourceManagerGateway = resourceManagerGateway;
        return this;
    }

    public DeclarativeSlotPoolBridgeBuilder setBatchSlotTimeout(Duration batchSlotTimeout) {
        this.batchSlotTimeout = batchSlotTimeout;
        return this;
    }

    public DeclarativeSlotPoolBridgeBuilder setIdleSlotTimeout(Duration idleSlotTimeout) {
        this.idleSlotTimeout = idleSlotTimeout;
        return this;
    }

    public DeclarativeSlotPoolBridgeBuilder setSlotRequestMaxInterval(Duration slotRequestMaxInterval) {
        this.slotRequestMaxInterval = slotRequestMaxInterval;
        return this;
    }

    public DeclarativeSlotPoolBridgeBuilder setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public DeclarativeSlotPoolBridgeBuilder setJobId(JobID jobId) {
        this.jobId = jobId;
        return this;
    }

    public DeclarativeSlotPoolBridgeBuilder setRequestSlotMatchingStrategy(RequestSlotMatchingStrategy requestSlotMatchingStrategy) {
        this.requestSlotMatchingStrategy = requestSlotMatchingStrategy;
        return this;
    }

    public DeclarativeSlotPoolBridgeBuilder setMainThreadExecutor(ComponentMainThreadExecutor mainThreadExecutor) {
        this.mainThreadExecutor = mainThreadExecutor;
        return this;
    }

    public DeclarativeSlotPoolBridgeBuilder setDeferSlotAllocation(boolean deferSlotAllocation) {
        this.deferSlotAllocation = deferSlotAllocation;
        return this;
    }

    public DeclarativeSlotPoolBridge build() {
        return new DeclarativeSlotPoolBridge(this.jobId, (DeclarativeSlotPoolFactory)new DefaultDeclarativeSlotPoolFactory(), this.clock, TestingUtils.infiniteDuration(), this.idleSlotTimeout, this.batchSlotTimeout, this.requestSlotMatchingStrategy, this.slotRequestMaxInterval, this.deferSlotAllocation, this.mainThreadExecutor);
    }

    public DeclarativeSlotPoolBridge buildAndStart() throws Exception {
        DeclarativeSlotPoolBridge slotPool = new DeclarativeSlotPoolBridge(this.jobId, (DeclarativeSlotPoolFactory)new DefaultDeclarativeSlotPoolFactory(), this.clock, TestingUtils.infiniteDuration(), this.idleSlotTimeout, this.batchSlotTimeout, this.requestSlotMatchingStrategy, this.slotRequestMaxInterval, this.deferSlotAllocation, this.mainThreadExecutor);
        slotPool.start(JobMasterId.generate(), "foobar");
        if (this.resourceManagerGateway != null) {
            CompletableFuture.runAsync(() -> slotPool.connectToResourceManager(this.resourceManagerGateway), (Executor)this.mainThreadExecutor).join();
        }
        return slotPool;
    }
}

