/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointTestUtils;
import org.apache.flink.runtime.checkpoint.metadata.MetadataSerializer;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV5Serializer;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class MetadataV5SerializerTest {
    private static final MetadataSerializer INSTANCE = MetadataV5Serializer.INSTANCE;
    private static final Random RND = new Random();
    private Collection<OperatorState> taskStates;
    private CheckpointMetadata metadata;

    MetadataV5SerializerTest() {
    }

    @BeforeEach
    public void beforeEach(@TempDir Path tempDir) throws IOException {
        this.taskStates = CheckpointTestUtils.createOperatorStates(RND, tempDir.toUri().toString(), 1, 0, 0, 0);
        this.metadata = new CheckpointMetadata(1L, this.taskStates, Collections.emptyList(), null);
    }

    @Test
    void testSerializeOperatorUidAndName() throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(out);){
            INSTANCE.serialize(this.metadata, dos);
            try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(out.toByteArray()));){
                CheckpointMetadata deserializedMetadata = INSTANCE.deserialize(dis, this.metadata.getClass().getClassLoader(), "");
                Collection operatorStates = deserializedMetadata.getOperatorStates();
                Assertions.assertThat((Collection)operatorStates).hasSize(1);
                OperatorState operatorState = (OperatorState)operatorStates.iterator().next();
                Assertions.assertThat((Optional)operatorState.getOperatorName()).isPresent();
                Assertions.assertThat((String)((String)operatorState.getOperatorName().get())).isEqualTo("operatorName-0");
                Assertions.assertThat((Optional)operatorState.getOperatorUid()).isPresent();
                Assertions.assertThat((String)((String)operatorState.getOperatorUid().get())).isEqualTo("operatorUid-0");
            }
        }
    }

    @Test
    void testSerializeOperatorNameWithEmptyValue() throws IOException {
        this.taskStates.iterator().next().setOperatorName("");
        this.testSerializeOperatorWithEmptyValue("Empty string operator name is not allowed");
    }

    @Test
    void testSerializeOperatorUidWithEmptyValue() throws IOException {
        this.taskStates.iterator().next().setOperatorUid("");
        this.testSerializeOperatorWithEmptyValue("Empty string operator uid is not allowed");
    }

    void testSerializeOperatorWithEmptyValue(String exceptionMessage) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(out);){
            IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> INSTANCE.serialize(this.metadata, dos));
            Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{exceptionMessage});
        }
    }
}

