/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.checkpoint.metadata.ChannelStateHandleSerializer;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.InputStateHandle;
import org.apache.flink.runtime.state.MergedInputChannelStateHandle;
import org.apache.flink.runtime.state.MergedResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.OutputStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.junit.jupiter.api.Assertions;

public class ChannelStateTestUtils {
    private static final int SUBTASK_INDEX_UPPER = 10000;

    public static InputChannelStateHandle randomInputChannelStateHandle() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        StreamStateHandle delegated = ChannelStateTestUtils.randomDelegatedHandle();
        return new InputChannelStateHandle(random.nextInt(0, 10000), new InputChannelInfo(random.nextInt(0, 10000), random.nextInt(0, 10000)), delegated, ChannelStateTestUtils.randomOffsets(), delegated.getStateSize());
    }

    public static ResultSubpartitionStateHandle randomResultSubpartitionStateHandle() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        StreamStateHandle delegated = ChannelStateTestUtils.randomDelegatedHandle();
        return new ResultSubpartitionStateHandle(random.nextInt(0, 10000), new ResultSubpartitionInfo(random.nextInt(0, 10000), random.nextInt(0, 10000)), delegated, ChannelStateTestUtils.randomOffsets(), delegated.getStateSize());
    }

    public static List<InputChannelStateHandle> randomInputChannelStateHandlesFromSameSubtask() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int subtaskIndex = random.nextInt(0, 10000);
        StreamStateHandle delegated = ChannelStateTestUtils.randomDelegatedHandle();
        int channelHandleCount = random.nextInt(20, 50);
        ArrayList<InputChannelStateHandle> inputHandles = new ArrayList<InputChannelStateHandle>(channelHandleCount);
        for (int i = 0; i < channelHandleCount; ++i) {
            inputHandles.add(new InputChannelStateHandle(subtaskIndex, new InputChannelInfo(random.nextInt(0, 10000), random.nextInt(0, 10000)), delegated, ChannelStateTestUtils.randomOffsets(), delegated.getStateSize()));
        }
        return inputHandles;
    }

    public static MergedInputChannelStateHandle randomMergedInputChannelStateHandle() {
        return MergedInputChannelStateHandle.fromChannelHandles(ChannelStateTestUtils.randomInputChannelStateHandlesFromSameSubtask());
    }

    public static List<ResultSubpartitionStateHandle> randomResultSubpartitionStateHandlesFromSameSubtask() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int subtaskIndex = random.nextInt(0, 10000);
        StreamStateHandle delegated = ChannelStateTestUtils.randomDelegatedHandle();
        int channelHandleCount = random.nextInt(20, 50);
        ArrayList<ResultSubpartitionStateHandle> outputHandles = new ArrayList<ResultSubpartitionStateHandle>(channelHandleCount);
        for (int i = 0; i < channelHandleCount; ++i) {
            outputHandles.add(new ResultSubpartitionStateHandle(subtaskIndex, new ResultSubpartitionInfo(random.nextInt(0, 10000), random.nextInt(0, 10000)), delegated, ChannelStateTestUtils.randomOffsets(), delegated.getStateSize()));
        }
        return outputHandles;
    }

    public static MergedResultSubpartitionStateHandle randomMergedResultSubpartitionStateHandle() {
        return MergedResultSubpartitionStateHandle.fromChannelHandles(ChannelStateTestUtils.randomResultSubpartitionStateHandlesFromSameSubtask());
    }

    private static StreamStateHandle randomDelegatedHandle() {
        byte[] randomBytes = String.valueOf(ThreadLocalRandom.current().nextLong()).getBytes();
        return new ByteStreamStateHandle("delegated", randomBytes);
    }

    private static List<Long> randomOffsets() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int offsetSize = random.nextInt(10, 20);
        ArrayList<Long> offsets = new ArrayList<Long>(offsetSize);
        for (int i = 0; i < offsetSize; ++i) {
            offsets.add(random.nextLong());
        }
        return offsets;
    }

    static void testSerializeInputHandle(ChannelStateHandleSerializer serializer, Supplier<InputStateHandle> handleGenerator) throws IOException {
        InputStateHandle inputHandle = handleGenerator.get();
        ByteArrayOutputStream inMemBuffer = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(inMemBuffer);
        serializer.serialize(inputHandle, outputStream);
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(inMemBuffer.toByteArray()));
        Assertions.assertEquals((Object)inputHandle, (Object)serializer.deserializeInputStateHandle(inputStream, null));
    }

    static void testSerializeOutputHandle(ChannelStateHandleSerializer serializer, Supplier<OutputStateHandle> handleGenerator) throws IOException {
        OutputStateHandle outputHandle = handleGenerator.get();
        ByteArrayOutputStream inMemBuffer = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(inMemBuffer);
        serializer.serialize(outputHandle, outputStream);
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(inMemBuffer.toByteArray()));
        Assertions.assertEquals((Object)outputHandle, (Object)serializer.deserializeOutputStateHandle(inputStream, null));
    }
}

