/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.assigners;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.WindowStagger;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;

@PublicEvolving
public class TumblingEventTimeWindows
extends WindowAssigner<Object, TimeWindow> {
    private static final long serialVersionUID = 1L;
    private final long size;
    private final long globalOffset;
    private Long staggerOffset = null;
    private final WindowStagger windowStagger;

    protected TumblingEventTimeWindows(long size, long offset, WindowStagger windowStagger) {
        if (Math.abs(offset) >= size) {
            throw new IllegalArgumentException("TumblingEventTimeWindows parameters must satisfy abs(offset) < size");
        }
        this.size = size;
        this.globalOffset = offset;
        this.windowStagger = windowStagger;
    }

    @Override
    public Collection<TimeWindow> assignWindows(Object element, long timestamp, WindowAssigner.WindowAssignerContext context) {
        if (timestamp > Long.MIN_VALUE) {
            if (this.staggerOffset == null) {
                this.staggerOffset = this.windowStagger.getStaggerOffset(context.getCurrentProcessingTime(), this.size);
            }
            long start = TimeWindow.getWindowStartWithOffset(timestamp, (this.globalOffset + this.staggerOffset) % this.size, this.size);
            return Collections.singletonList(new TimeWindow(start, start + this.size));
        }
        throw new RuntimeException("Record has Long.MIN_VALUE timestamp (= no timestamp marker). Did you forget to call 'DataStream.assignTimestampsAndWatermarks(...)'?");
    }

    @Override
    public Trigger<Object, TimeWindow> getDefaultTrigger() {
        return EventTimeTrigger.create();
    }

    public String toString() {
        return "TumblingEventTimeWindows(" + this.size + ")";
    }

    public static TumblingEventTimeWindows of(Duration size) {
        return new TumblingEventTimeWindows(size.toMillis(), 0L, WindowStagger.ALIGNED);
    }

    public static TumblingEventTimeWindows of(Duration size, Duration offset) {
        return new TumblingEventTimeWindows(size.toMillis(), offset.toMillis(), WindowStagger.ALIGNED);
    }

    @PublicEvolving
    public static TumblingEventTimeWindows of(Duration size, Duration offset, WindowStagger windowStagger) {
        return new TumblingEventTimeWindows(size.toMillis(), offset.toMillis(), windowStagger);
    }

    @Override
    public TypeSerializer<TimeWindow> getWindowSerializer(ExecutionConfig executionConfig) {
        return new TimeWindow.Serializer();
    }

    @Override
    public boolean isEventTime() {
        return true;
    }
}

