/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sortpartition;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

final class KeyAndValueSerializer<INPUT>
extends TypeSerializer<Tuple2<byte[], INPUT>> {
    private final TypeSerializer<INPUT> valueSerializer;
    private final int serializedKeyLength;

    KeyAndValueSerializer(TypeSerializer<INPUT> valueSerializer, int serializedKeyLength) {
        this.valueSerializer = valueSerializer;
        this.serializedKeyLength = serializedKeyLength;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<Tuple2<byte[], INPUT>> duplicate() {
        return new KeyAndValueSerializer<INPUT>(this.valueSerializer.duplicate(), this.serializedKeyLength);
    }

    public Tuple2<byte[], INPUT> copy(Tuple2<byte[], INPUT> from) {
        Object record = from.f1;
        return Tuple2.of((Object)Arrays.copyOf((byte[])from.f0, ((byte[])from.f0).length), (Object)this.valueSerializer.copy(record));
    }

    public Tuple2<byte[], INPUT> createInstance() {
        return Tuple2.of((Object)new byte[0], (Object)this.valueSerializer.createInstance());
    }

    public Tuple2<byte[], INPUT> copy(Tuple2<byte[], INPUT> from, Tuple2<byte[], INPUT> reuse) {
        reuse.f0 = Arrays.copyOf((byte[])from.f0, ((byte[])from.f0).length);
        Object fromRecord = from.f1;
        reuse.f1 = this.valueSerializer.copy(fromRecord, reuse.f1);
        return reuse;
    }

    public int getLength() {
        if (this.valueSerializer.getLength() < 0 || this.serializedKeyLength < 0) {
            return -1;
        }
        return this.valueSerializer.getLength() + this.serializedKeyLength;
    }

    public void serialize(Tuple2<byte[], INPUT> record, DataOutputView target) throws IOException {
        if (this.serializedKeyLength < 0) {
            target.writeInt(((byte[])record.f0).length);
        }
        target.write((byte[])record.f0);
        Object toSerialize = record.f1;
        this.valueSerializer.serialize(toSerialize, target);
    }

    public Tuple2<byte[], INPUT> deserialize(DataInputView source) throws IOException {
        int length = this.getKeyLength(source);
        byte[] bytes = new byte[length];
        source.read(bytes);
        Object value = this.valueSerializer.deserialize(source);
        return Tuple2.of((Object)bytes, (Object)value);
    }

    public Tuple2<byte[], INPUT> deserialize(Tuple2<byte[], INPUT> reuse, DataInputView source) throws IOException {
        int length = this.getKeyLength(source);
        byte[] bytes = new byte[length];
        source.read(bytes);
        Object value = this.valueSerializer.deserialize(source);
        reuse.f0 = bytes;
        reuse.f1 = value;
        return reuse;
    }

    private int getKeyLength(DataInputView source) throws IOException {
        int length = this.serializedKeyLength < 0 ? source.readInt() : this.serializedKeyLength;
        return length;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length;
        if (this.serializedKeyLength < 0) {
            length = source.readInt();
            target.writeInt(length);
        } else {
            length = this.serializedKeyLength;
        }
        for (int i = 0; i < length; ++i) {
            target.writeByte((int)source.readByte());
        }
        this.valueSerializer.copy(source, target);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KeyAndValueSerializer that = (KeyAndValueSerializer)((Object)o);
        return Objects.equals(this.valueSerializer, that.valueSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.valueSerializer);
    }

    public TypeSerializerSnapshot<Tuple2<byte[], INPUT>> snapshotConfiguration() {
        throw new UnsupportedOperationException();
    }
}

