/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.lineage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.lineage.LineageEdge;
import org.apache.flink.streaming.api.lineage.LineageGraph;
import org.apache.flink.streaming.api.lineage.LineageVertex;
import org.apache.flink.streaming.api.lineage.SourceLineageVertex;

@Internal
public class DefaultLineageGraph
implements LineageGraph {
    @JsonProperty
    private final List<LineageEdge> lineageEdges;
    @JsonProperty
    private final Set<SourceLineageVertex> sources;
    @JsonProperty
    private final Set<LineageVertex> sinks;

    private DefaultLineageGraph(List<LineageEdge> lineageEdges) {
        this.lineageEdges = lineageEdges;
        this.sources = new HashSet<SourceLineageVertex>();
        this.sinks = new HashSet<LineageVertex>();
        for (LineageEdge lineageEdge : lineageEdges) {
            this.sources.add(lineageEdge.source());
            this.sinks.add(lineageEdge.sink());
        }
    }

    @Override
    public List<SourceLineageVertex> sources() {
        return List.copyOf(this.sources);
    }

    @Override
    public List<LineageVertex> sinks() {
        return List.copyOf(this.sinks);
    }

    @Override
    public List<LineageEdge> relations() {
        return Collections.unmodifiableList(this.lineageEdges);
    }

    void addSources(List<SourceLineageVertex> partialSources) {
        this.sources.addAll(partialSources);
    }

    void addSinks(List<LineageVertex> partialSinks) {
        this.sinks.addAll(partialSinks);
    }

    public static LineageGraphBuilder builder() {
        return new LineageGraphBuilder();
    }

    @Internal
    public static class LineageGraphBuilder {
        private final List<LineageEdge> lineageEdges = new ArrayList<LineageEdge>();
        private final List<SourceLineageVertex> sources = new ArrayList<SourceLineageVertex>();
        private final List<LineageVertex> sinks = new ArrayList<LineageVertex>();

        private LineageGraphBuilder() {
        }

        public LineageGraphBuilder addLineageEdge(LineageEdge lineageEdge) {
            this.lineageEdges.add(lineageEdge);
            return this;
        }

        public LineageGraphBuilder addLineageEdges(LineageEdge ... lineageEdges) {
            this.lineageEdges.addAll(Arrays.asList(lineageEdges));
            return this;
        }

        public LineageGraphBuilder addSourceVertex(SourceLineageVertex sourceVertex) {
            this.sources.add(sourceVertex);
            return this;
        }

        public LineageGraphBuilder addSourceVertexes(SourceLineageVertex ... sourceVertexes) {
            this.sources.addAll(Arrays.asList(sourceVertexes));
            return this;
        }

        public LineageGraphBuilder addSinkVertex(LineageVertex sinkVertex) {
            this.sinks.add(sinkVertex);
            return this;
        }

        public LineageGraphBuilder addSinkVertexes(List<LineageVertex> sinkVertex) {
            this.sinks.addAll(sinkVertex);
            return this;
        }

        public LineageGraph build() {
            DefaultLineageGraph lineageGraph = new DefaultLineageGraph(this.lineageEdges);
            lineageGraph.addSinks(this.sinks);
            lineageGraph.addSources(this.sources);
            return lineageGraph;
        }
    }
}

