/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source.legacy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.source.legacy.SourceFunction;
import org.apache.flink.streaming.api.lineage.DefaultLineageDataset;
import org.apache.flink.streaming.api.lineage.LineageDataset;
import org.apache.flink.streaming.api.lineage.LineageDatasetFacet;
import org.apache.flink.streaming.api.lineage.LineageVertex;
import org.apache.flink.streaming.api.lineage.LineageVertexProvider;
import org.apache.flink.streaming.api.lineage.SourceLineageVertex;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class FromElementsFunction<T>
implements SourceFunction<T>,
CheckpointedFunction,
OutputTypeConfigurable<T>,
LineageVertexProvider {
    private static final String LINEAGE_NAMESPACE = "values://FromElementsFunction";
    private static final long serialVersionUID = 1L;
    @Nullable
    private TypeSerializer<T> serializer;
    private byte[] elementsSerialized;
    private final int numElements;
    private volatile int numElementsEmitted;
    private volatile int numElementsToSkip;
    private volatile boolean isRunning = true;
    private final transient Iterable<T> elements;
    private transient ListState<Integer> checkpointedState;

    @SafeVarargs
    public FromElementsFunction(TypeSerializer<T> serializer, T ... elements) throws IOException {
        this(serializer, (Iterable<T>)Arrays.asList(elements));
    }

    public FromElementsFunction(TypeSerializer<T> serializer, Iterable<T> elements) throws IOException {
        this.serializer = (TypeSerializer)Preconditions.checkNotNull(serializer);
        this.elements = elements;
        this.numElements = elements instanceof Collection ? ((Collection)elements).size() : (int)IterableUtils.toStream(elements).count();
        this.serializeElements();
    }

    @SafeVarargs
    public FromElementsFunction(T ... elements) {
        this((Iterable<T>)Arrays.asList(elements));
    }

    public FromElementsFunction(Iterable<T> elements) {
        this.serializer = null;
        this.elements = elements;
        this.numElements = elements instanceof Collection ? ((Collection)elements).size() : (int)IterableUtils.toStream(elements).count();
        FromElementsFunction.checkIterable(elements, Object.class);
    }

    @Nullable
    @VisibleForTesting
    public TypeSerializer<T> getSerializer() {
        return this.serializer;
    }

    private void serializeElements() throws IOException {
        Preconditions.checkState((this.serializer != null ? 1 : 0) != 0, (Object)"serializer not set");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper wrapper = new DataOutputViewStreamWrapper((OutputStream)baos);
        try {
            for (T element : this.elements) {
                this.serializer.serialize(element, (DataOutputView)wrapper);
            }
        }
        catch (Exception e) {
            throw new IOException("Serializing the source elements failed: " + e.getMessage(), e);
        }
        this.elementsSerialized = baos.toByteArray();
    }

    public void setOutputType(TypeInformation<T> outTypeInfo, ExecutionConfig executionConfig) {
        Preconditions.checkState((this.elements != null ? 1 : 0) != 0, (Object)"The output type should've been specified before shipping the graph to the cluster");
        FromElementsFunction.checkIterable(this.elements, outTypeInfo.getTypeClass());
        TypeSerializer newSerializer = outTypeInfo.createSerializer(executionConfig.getSerializerConfig());
        if (Objects.equals(this.serializer, newSerializer)) {
            return;
        }
        this.serializer = newSerializer;
        try {
            this.serializeElements();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void initializeState(FunctionInitializationContext context) throws Exception {
        Preconditions.checkState((this.checkpointedState == null ? 1 : 0) != 0, (Object)("The " + this.getClass().getSimpleName() + " has already been initialized."));
        this.checkpointedState = context.getOperatorStateStore().getListState(new ListStateDescriptor("from-elements-state", (TypeSerializer)IntSerializer.INSTANCE));
        if (context.isRestored()) {
            ArrayList<Integer> retrievedStates = new ArrayList<Integer>();
            for (Integer entry : (Iterable)this.checkpointedState.get()) {
                retrievedStates.add(entry);
            }
            Preconditions.checkArgument((retrievedStates.size() == 1 ? 1 : 0) != 0, (Object)(this.getClass().getSimpleName() + " retrieved invalid state."));
            this.numElementsToSkip = (Integer)retrievedStates.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(SourceFunction.SourceContext<T> ctx) throws Exception {
        int toSkip;
        Preconditions.checkState((this.serializer != null ? 1 : 0) != 0, (Object)"serializer not configured");
        ByteArrayInputStream bais = new ByteArrayInputStream(this.elementsSerialized);
        DataInputViewStreamWrapper input = new DataInputViewStreamWrapper((InputStream)bais);
        if (toSkip > 0) {
            try {
                for (toSkip = this.numElementsToSkip; toSkip > 0; --toSkip) {
                    this.serializer.deserialize((DataInputView)input);
                }
            }
            catch (Exception e) {
                throw new IOException("Failed to deserialize an element from the source. If you are using user-defined serialization (Value and Writable types), check the serialization functions.\nSerializer is " + String.valueOf(this.serializer), e);
            }
            this.numElementsEmitted = this.numElementsToSkip;
        }
        Object lock = ctx.getCheckpointLock();
        while (this.isRunning && this.numElementsEmitted < this.numElements) {
            Object next;
            try {
                next = this.serializer.deserialize((DataInputView)input);
            }
            catch (Exception e) {
                throw new IOException("Failed to deserialize an element from the source. If you are using user-defined serialization (Value and Writable types), check the serialization functions.\nSerializer is " + String.valueOf(this.serializer), e);
            }
            Object object = lock;
            synchronized (object) {
                ctx.collect(next);
                ++this.numElementsEmitted;
            }
        }
    }

    @Override
    public void cancel() {
        this.isRunning = false;
    }

    public int getNumElements() {
        return this.numElements;
    }

    public int getNumElementsEmitted() {
        return this.numElementsEmitted;
    }

    @Override
    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        Preconditions.checkState((this.checkpointedState != null ? 1 : 0) != 0, (Object)("The " + this.getClass().getSimpleName() + " has not been properly initialized."));
        this.checkpointedState.update(Collections.singletonList(this.numElementsEmitted));
    }

    public static <OUT> void checkCollection(Collection<OUT> elements, Class<OUT> viewedAs) {
        FromElementsFunction.checkIterable(elements, viewedAs);
    }

    private static <OUT> void checkIterable(Iterable<OUT> elements, Class<?> viewedAs) {
        for (OUT elem : elements) {
            if (elem == null) {
                throw new IllegalArgumentException("The collection contains a null element");
            }
            if (viewedAs.isAssignableFrom(elem.getClass())) continue;
            throw new IllegalArgumentException("The elements in the collection are not all subclasses of " + viewedAs.getCanonicalName());
        }
    }

    @Override
    public LineageVertex getLineageVertex() {
        return new SourceLineageVertex(){

            @Override
            public Boundedness boundedness() {
                return Boundedness.BOUNDED;
            }

            @Override
            public List<LineageDataset> datasets() {
                return Arrays.asList(new DefaultLineageDataset("", FromElementsFunction.LINEAGE_NAMESPACE, new HashMap<String, LineageDatasetFacet>()));
            }
        };
    }
}

