/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.hashmap;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.BackendBuildingException;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.DefaultOperatorStateBackendBuilder;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackendBuilder;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSetFactory;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.SizeTrackingStateConfig;

@PublicEvolving
public class HashMapStateBackend
extends AbstractStateBackend
implements ConfigurableStateBackend {
    private static final long serialVersionUID = 1L;

    public HashMapStateBackend() {
    }

    private HashMapStateBackend(HashMapStateBackend original, ReadableConfig config) {
        this.latencyTrackingConfigBuilder = original.latencyTrackingConfigBuilder.configure(config);
        this.sizeTrackingConfigBuilder = original.sizeTrackingConfigBuilder.configure(config);
    }

    @Override
    public HashMapStateBackend configure(ReadableConfig config, ClassLoader classLoader) throws IllegalConfigurationException {
        return new HashMapStateBackend(this, config);
    }

    @Override
    public boolean supportsNoClaimRestoreMode() {
        return true;
    }

    @Override
    public boolean supportsSavepointFormat(SavepointFormatType formatType) {
        return true;
    }

    @Override
    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(StateBackend.KeyedStateBackendParameters<K> parameters) throws IOException {
        TaskStateManager taskStateManager = parameters.getEnv().getTaskStateManager();
        LocalRecoveryConfig localRecoveryConfig = taskStateManager.createLocalRecoveryConfig();
        HeapPriorityQueueSetFactory priorityQueueSetFactory = new HeapPriorityQueueSetFactory(parameters.getKeyGroupRange(), parameters.getNumberOfKeyGroups(), 128);
        LatencyTrackingStateConfig latencyTrackingStateConfig = ((LatencyTrackingStateConfig.Builder)this.latencyTrackingConfigBuilder.setMetricGroup(parameters.getMetricGroup())).build();
        SizeTrackingStateConfig sizeTrackingStateConfig = ((SizeTrackingStateConfig.Builder)this.sizeTrackingConfigBuilder.setMetricGroup(parameters.getMetricGroup())).build();
        return new HeapKeyedStateBackendBuilder<K>(parameters.getKvStateRegistry(), parameters.getKeySerializer(), parameters.getEnv().getUserCodeClassLoader().asClassLoader(), parameters.getNumberOfKeyGroups(), parameters.getKeyGroupRange(), parameters.getEnv().getExecutionConfig(), parameters.getTtlTimeProvider(), latencyTrackingStateConfig, sizeTrackingStateConfig, parameters.getStateHandles(), HashMapStateBackend.getCompressionDecorator(parameters.getEnv().getExecutionConfig()), localRecoveryConfig, priorityQueueSetFactory, true, parameters.getCancelStreamRegistry()).build();
    }

    @Override
    public OperatorStateBackend createOperatorStateBackend(StateBackend.OperatorStateBackendParameters parameters) throws BackendBuildingException {
        return new DefaultOperatorStateBackendBuilder(parameters.getEnv().getUserCodeClassLoader().asClassLoader(), parameters.getEnv().getExecutionConfig(), true, parameters.getStateHandles(), parameters.getCancelStreamRegistry()).build();
    }
}

