/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.filesystem.FsCompletedCheckpointStorageLocation;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;

public abstract class AbstractFsCheckpointStorageAccess
implements CheckpointStorageAccess {
    public static final String CHECKPOINT_DIR_PREFIX = "chk-";
    public static final String CHECKPOINT_SHARED_STATE_DIR = "shared";
    public static final String CHECKPOINT_TASK_OWNED_STATE_DIR = "taskowned";
    public static final String METADATA_FILE_NAME = "_metadata";
    private static final byte[] REFERENCE_MAGIC_NUMBER = new byte[]{5, 95, 63, 24};
    private final JobID jobId;
    @Nullable
    private final Path defaultSavepointDirectory;

    protected AbstractFsCheckpointStorageAccess(JobID jobId, @Nullable Path defaultSavepointDirectory) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.defaultSavepointDirectory = defaultSavepointDirectory;
    }

    @Nullable
    public Path getDefaultSavepointDirectory() {
        return this.defaultSavepointDirectory;
    }

    @Override
    public boolean hasDefaultSavepointLocation() {
        return this.defaultSavepointDirectory != null;
    }

    @Override
    public CompletedCheckpointStorageLocation resolveCheckpoint(String checkpointPointer) throws IOException {
        return AbstractFsCheckpointStorageAccess.resolveCheckpointPointer(checkpointPointer);
    }

    @Override
    public CheckpointStorageLocation initializeLocationForSavepoint(long checkpointId, @Nullable String externalLocationPointer) throws IOException {
        Path savepointBasePath;
        if (externalLocationPointer != null) {
            savepointBasePath = new Path(externalLocationPointer);
        } else if (this.defaultSavepointDirectory != null) {
            savepointBasePath = this.defaultSavepointDirectory;
        } else {
            throw new IllegalArgumentException("No savepoint location given and no default location configured.");
        }
        FileSystem fs = savepointBasePath.getFileSystem();
        String prefix = "savepoint-" + this.jobId.toString().substring(0, 6) + "-";
        Exception latestException = null;
        for (int attempt = 0; attempt < 10; ++attempt) {
            Path path = new Path(savepointBasePath, FileUtils.getRandomFilename((String)prefix));
            try {
                if (!fs.mkdirs(path)) continue;
                Path qp = path.makeQualified(fs);
                return this.createSavepointLocation(fs, qp);
            }
            catch (Exception e) {
                latestException = e;
            }
        }
        throw new IOException("Failed to create savepoint directory at " + String.valueOf(savepointBasePath), latestException);
    }

    protected abstract CheckpointStorageLocation createSavepointLocation(FileSystem var1, Path var2) throws IOException;

    protected static Path getCheckpointDirectoryForJob(Path baseCheckpointPath, JobID jobId) {
        return new Path(baseCheckpointPath, jobId.toString());
    }

    protected static Path createCheckpointDirectory(Path baseDirectory, long checkpointId) {
        return new Path(baseDirectory, CHECKPOINT_DIR_PREFIX + checkpointId);
    }

    @Internal
    public static FsCompletedCheckpointStorageLocation resolveCheckpointPointer(String checkpointPointer) throws IOException {
        FileStatus metadataFileStatus;
        Path checkpointDir;
        FileStatus status;
        FileSystem fs;
        Path path;
        Preconditions.checkNotNull((Object)checkpointPointer, (String)"checkpointPointer");
        Preconditions.checkArgument((!checkpointPointer.isEmpty() ? 1 : 0) != 0, (Object)"empty checkpoint pointer");
        try {
            path = new Path(checkpointPointer);
        }
        catch (Exception e) {
            throw new IOException("Checkpoint/savepoint path '" + checkpointPointer + "' is not a valid file URI. Either the pointer path is invalid, or the checkpoint was created by a different state backend.");
        }
        try {
            fs = path.getFileSystem();
        }
        catch (IOException e) {
            throw new IOException("Cannot access file system for checkpoint/savepoint path '" + checkpointPointer + "'.", e);
        }
        try {
            status = fs.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("Cannot find checkpoint or savepoint file/directory '" + checkpointPointer + "' on file system '" + fs.getUri().getScheme() + "'.");
        }
        if (status.isDir()) {
            checkpointDir = status.getPath();
            Path metadataFilePath = new Path(path, METADATA_FILE_NAME);
            try {
                metadataFileStatus = fs.getFileStatus(metadataFilePath);
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Cannot find meta data file '_metadata' in directory '" + String.valueOf(path) + "'. Please try to load the checkpoint/savepoint directly from the metadata file instead of the directory.");
            }
        } else {
            metadataFileStatus = status;
            checkpointDir = status.getPath().getParent();
        }
        FileStateHandle metaDataFileHandle = new FileStateHandle(metadataFileStatus.getPath(), metadataFileStatus.getLen());
        String pointer = checkpointDir.makeQualified(fs).toString();
        return new FsCompletedCheckpointStorageLocation(fs, checkpointDir, metaDataFileHandle, pointer);
    }

    public static CheckpointStorageLocationReference encodePathAsReference(Path path) {
        byte[] refBytes = path.toString().getBytes(StandardCharsets.UTF_8);
        byte[] bytes = new byte[REFERENCE_MAGIC_NUMBER.length + refBytes.length];
        System.arraycopy(REFERENCE_MAGIC_NUMBER, 0, bytes, 0, REFERENCE_MAGIC_NUMBER.length);
        System.arraycopy(refBytes, 0, bytes, REFERENCE_MAGIC_NUMBER.length, refBytes.length);
        return new CheckpointStorageLocationReference(bytes);
    }

    public static Path decodePathFromReference(CheckpointStorageLocationReference reference) {
        int headerLen;
        if (reference.isDefaultReference()) {
            throw new IllegalArgumentException("Cannot decode default reference");
        }
        byte[] bytes = reference.getReferenceBytes();
        if (bytes.length > (headerLen = REFERENCE_MAGIC_NUMBER.length)) {
            for (int i = 0; i < headerLen; ++i) {
                if (bytes[i] == REFERENCE_MAGIC_NUMBER[i]) continue;
                throw new IllegalArgumentException("Reference starts with the wrong magic number");
            }
            try {
                return new Path(new String(bytes, headerLen, bytes.length - headerLen, StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Reference cannot be decoded to a path", e);
            }
        }
        throw new IllegalArgumentException("Reference too short.");
    }
}

