/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class ExceptionHistoryEntry
extends ErrorInfo {
    private static final long serialVersionUID = -3855285510064263701L;
    @Nullable
    private final String failingTaskName;
    @Nullable
    private final ArchivedTaskManagerLocation taskManagerLocation;
    private final transient CompletableFuture<Map<String, String>> failureLabelsFuture;
    private Map<String, String> failureLabels;

    public static ExceptionHistoryEntry create(AccessExecution failedExecution, String taskName, CompletableFuture<Map<String, String>> failureLabels) {
        Preconditions.checkNotNull((Object)failedExecution, (String)"No Execution is specified.");
        Preconditions.checkNotNull((Object)taskName, (String)"No task name is specified.");
        Preconditions.checkArgument((boolean)failedExecution.getFailureInfo().isPresent(), (Object)("The selected Execution " + String.valueOf(failedExecution.getAttemptId()) + " didn't fail."));
        ErrorInfo failure = failedExecution.getFailureInfo().get();
        return new ExceptionHistoryEntry((Throwable)failure.getException(), failure.getTimestamp(), failureLabels, taskName, failedExecution.getAssignedResourceLocation());
    }

    public static ExceptionHistoryEntry createGlobal(Throwable cause, CompletableFuture<Map<String, String>> failureLabels) {
        return new ExceptionHistoryEntry(cause, System.currentTimeMillis(), failureLabels, null, (ArchivedTaskManagerLocation)null);
    }

    protected ExceptionHistoryEntry(Throwable cause, long timestamp, CompletableFuture<Map<String, String>> failureLabels, @Nullable String failingTaskName, @Nullable TaskManagerLocation taskManagerLocation) {
        this(cause, timestamp, failureLabels, failingTaskName, ArchivedTaskManagerLocation.fromTaskManagerLocation(taskManagerLocation));
    }

    private ExceptionHistoryEntry(Throwable cause, long timestamp, CompletableFuture<Map<String, String>> failureLabels, @Nullable String failingTaskName, @Nullable ArchivedTaskManagerLocation taskManagerLocation) {
        super(cause, timestamp);
        this.failingTaskName = failingTaskName;
        this.taskManagerLocation = taskManagerLocation;
        this.failureLabelsFuture = ((CompletableFuture)Preconditions.checkNotNull(failureLabels)).thenApply(labelMap -> {
            this.failureLabels = Collections.unmodifiableMap(labelMap);
            return this.failureLabels;
        });
    }

    public boolean isGlobal() {
        return this.failingTaskName == null;
    }

    @Nullable
    public String getFailingTaskName() {
        return this.failingTaskName;
    }

    @Nullable
    public ArchivedTaskManagerLocation getTaskManagerLocation() {
        return this.taskManagerLocation;
    }

    public Map<String, String> getFailureLabels() {
        return Optional.ofNullable(this.failureLabels).orElse(Collections.emptyMap());
    }

    public CompletableFuture<Map<String, String>> getFailureLabelsFuture() {
        return this.failureLabelsFuture;
    }

    public static class ArchivedTaskManagerLocation
    implements Serializable {
        private static final long serialVersionUID = -6596854145482446664L;
        private final ResourceID resourceID;
        private final String addressStr;
        private final int port;
        private final String hostname;
        private final String fqdnHostname;

        @Nullable
        @VisibleForTesting
        static ArchivedTaskManagerLocation fromTaskManagerLocation(TaskManagerLocation taskManagerLocation) {
            if (taskManagerLocation == null) {
                return null;
            }
            return new ArchivedTaskManagerLocation(taskManagerLocation.getResourceID(), taskManagerLocation.addressString(), taskManagerLocation.dataPort(), taskManagerLocation.getHostname(), taskManagerLocation.getFQDNHostname());
        }

        private ArchivedTaskManagerLocation(ResourceID resourceID, String addressStr, int port, String hostname, String fqdnHost) {
            this.resourceID = resourceID;
            this.addressStr = addressStr;
            this.port = port;
            this.hostname = hostname;
            this.fqdnHostname = fqdnHost;
        }

        public ResourceID getResourceID() {
            return this.resourceID;
        }

        public String getAddress() {
            return this.addressStr;
        }

        public int getPort() {
            return this.port;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getFQDNHostname() {
            return this.fqdnHostname;
        }

        public String getEndpoint() {
            return String.format("%s:%d", this.fqdnHostname, this.port);
        }

        public String toString() {
            return new StringJoiner(", ", ArchivedTaskManagerLocation.class.getSimpleName() + "[", "]").add("resourceID=" + String.valueOf(this.resourceID)).add("addressStr='" + this.addressStr + "'").add("port=" + this.port).add("hostname='" + this.hostname + "'").add("fqdnHostname='" + this.fqdnHostname + "'").toString();
        }
    }
}

