/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.router;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.runtime.rest.handler.router.PathPattern;
import org.apache.flink.runtime.rest.handler.router.Router;

public class MultipartRoutes {
    private final List<PathPattern> postRoutes;
    private final List<PathPattern> fileUploadRoutes;

    private MultipartRoutes(List<PathPattern> postRoutes, List<PathPattern> fileUploadRoutes) {
        this.postRoutes = new ArrayList<PathPattern>(postRoutes);
        this.fileUploadRoutes = new ArrayList<PathPattern>(fileUploadRoutes);
    }

    public boolean isPostRoute(String requestUri) {
        return this.checkRoutes(requestUri, this.postRoutes);
    }

    public boolean isFileUploadRoute(String requestUri) {
        return this.checkRoutes(requestUri, this.fileUploadRoutes);
    }

    public String toString() {
        return "MultipartRoutes{postRoutes=" + String.valueOf(this.postRoutes) + ", fileUploadRoutes=" + String.valueOf(this.fileUploadRoutes) + "}";
    }

    private boolean checkRoutes(String requestUri, List<PathPattern> routes) {
        String[] pathTokens = Router.decodePathTokens(requestUri);
        HashMap<String, String> params = new HashMap<String, String>();
        for (PathPattern route : routes) {
            if (!route.match(pathTokens, params)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private final List<PathPattern> postRoutes = new ArrayList<PathPattern>();
        private final List<PathPattern> fileUploadRoutes = new ArrayList<PathPattern>();

        public Builder addPostRoute(String pattern) {
            this.postRoutes.add(new PathPattern(pattern));
            return this;
        }

        public Builder addFileUploadRoute(String pattern) {
            this.fileUploadRoutes.add(new PathPattern(pattern));
            return this;
        }

        public MultipartRoutes build() {
            return new MultipartRoutes(this.postRoutes, this.fileUploadRoutes);
        }
    }
}

