/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.util.Preconditions;

@Internal
public class TaskManagerMetricGroup
extends ComponentMetricGroup<TaskManagerMetricGroup> {
    private final Map<JobID, TaskManagerJobMetricGroup> jobs = new HashMap<JobID, TaskManagerJobMetricGroup>();
    private final String hostname;
    private final String taskManagerId;

    TaskManagerMetricGroup(MetricRegistry registry, String hostname, String taskManagerId) {
        super(registry, registry.getScopeFormats().getTaskManagerFormat().formatScope(hostname, taskManagerId), null);
        this.hostname = hostname;
        this.taskManagerId = taskManagerId;
    }

    public static TaskManagerMetricGroup createTaskManagerMetricGroup(MetricRegistry metricRegistry, String hostName, ResourceID resourceID) {
        return new TaskManagerMetricGroup(metricRegistry, hostName, resourceID.toString());
    }

    public String hostname() {
        return this.hostname;
    }

    public String taskManagerId() {
        return this.taskManagerId;
    }

    @Override
    protected QueryScopeInfo.TaskManagerQueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        return new QueryScopeInfo.TaskManagerQueryScopeInfo(this.taskManagerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskManagerJobMetricGroup addJob(JobID jobId, String jobName) {
        TaskManagerJobMetricGroup jobGroup;
        Preconditions.checkNotNull((Object)jobId);
        String resolvedJobName = jobName == null || jobName.isEmpty() ? jobId.toString() : jobName;
        TaskManagerMetricGroup taskManagerMetricGroup = this;
        synchronized (taskManagerMetricGroup) {
            jobGroup = this.jobs.get(jobId);
            if (jobGroup == null) {
                jobGroup = new TaskManagerJobMetricGroup(this.registry, this, jobId, resolvedJobName);
                this.jobs.put(jobId, jobGroup);
            }
        }
        return jobGroup;
    }

    @VisibleForTesting
    public TaskManagerJobMetricGroup getJobMetricsGroup(JobID jobId) {
        return this.jobs.get(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobMetricsGroup(JobID jobId) {
        if (jobId != null) {
            TaskManagerJobMetricGroup groupToClose;
            TaskManagerMetricGroup taskManagerMetricGroup = this;
            synchronized (taskManagerMetricGroup) {
                groupToClose = this.jobs.remove(jobId);
            }
            if (groupToClose != null) {
                groupToClose.close();
            }
        }
    }

    public int numRegisteredJobMetricGroups() {
        return this.jobs.size();
    }

    @Override
    protected void putVariables(Map<String, String> variables) {
        variables.put(ScopeFormat.SCOPE_HOST, this.hostname);
        variables.put(ScopeFormat.SCOPE_TASKMANAGER_ID, this.taskManagerId);
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup<?>> subComponents() {
        return this.jobs.values();
    }

    @Override
    protected String getGroupName(CharacterFilter filter) {
        return "taskmanager";
    }
}

