/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.event;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.event.JobEvent;
import org.apache.flink.runtime.jobmaster.event.JobEvents;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.shuffle.ShuffleMasterSnapshot;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class ExecutionVertexFinishedEvent
implements JobEvent {
    private final ExecutionAttemptID executionAttemptId;
    private final TaskManagerLocation taskManagerLocation;
    private transient Map<OperatorID, CompletableFuture<byte[]>> operatorCoordinatorSnapshotFutures;
    @Nullable
    private transient CompletableFuture<ShuffleMasterSnapshot> shuffleMasterSnapshotFuture;
    private final IOMetrics ioMetrics;
    @Nullable
    private final Map<String, Accumulator<?, ?>> userAccumulators;

    public ExecutionVertexFinishedEvent(ExecutionAttemptID executionAttemptId, TaskManagerLocation location, Map<OperatorID, CompletableFuture<byte[]>> operatorCoordinatorSnapshotFutures, @Nullable CompletableFuture<ShuffleMasterSnapshot> shuffleMasterSnapshotFuture, IOMetrics ioMetrics, @Nullable Map<String, Accumulator<?, ?>> userAccumulators) {
        this.executionAttemptId = (ExecutionAttemptID)Preconditions.checkNotNull((Object)executionAttemptId);
        this.taskManagerLocation = (TaskManagerLocation)Preconditions.checkNotNull((Object)location);
        this.operatorCoordinatorSnapshotFutures = (Map)Preconditions.checkNotNull(operatorCoordinatorSnapshotFutures);
        this.shuffleMasterSnapshotFuture = shuffleMasterSnapshotFuture;
        this.ioMetrics = ioMetrics;
        this.userAccumulators = userAccumulators;
    }

    public ExecutionAttemptID getExecutionAttemptId() {
        return this.executionAttemptId;
    }

    public ExecutionVertexID getExecutionVertexId() {
        return this.executionAttemptId.getExecutionVertexId();
    }

    public int getAttemptNumber() {
        return this.executionAttemptId.getAttemptNumber();
    }

    public TaskManagerLocation getTaskManagerLocation() {
        return this.taskManagerLocation;
    }

    public Map<OperatorID, CompletableFuture<byte[]>> getOperatorCoordinatorSnapshotFutures() {
        return this.operatorCoordinatorSnapshotFutures;
    }

    @Nullable
    public CompletableFuture<ShuffleMasterSnapshot> getShuffleMasterSnapshotFuture() {
        return this.shuffleMasterSnapshotFuture;
    }

    public IOMetrics getIOMetrics() {
        return this.ioMetrics;
    }

    @Nullable
    public Map<String, Accumulator<?, ?>> getUserAccumulators() {
        return this.userAccumulators;
    }

    public boolean hasOperatorCoordinatorAndShuffleMasterSnapshots() {
        return this.shuffleMasterSnapshotFuture != null;
    }

    public String toString() {
        return "ExecutionVertexFinishedEvent(executionVertexId='" + String.valueOf(this.getExecutionVertexId()) + "', attemptNumber='" + this.getAttemptNumber() + "')";
    }

    static class Serializer
    implements SimpleVersionedSerializer<JobEvent> {
        private static final int VERSION = 1;
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        public int getVersion() {
            return 1;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public byte[] serialize(JobEvent jobEvent) throws IOException {
            Preconditions.checkState((jobEvent.getType() == JobEvents.getTypeID(ExecutionVertexFinishedEvent.class) ? 1 : 0) != 0);
            ExecutionVertexFinishedEvent event = (ExecutionVertexFinishedEvent)jobEvent;
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                byte[] byArray;
                try (DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)byteArrayOutputStream);){
                    byte[] binaryJobEvent = InstantiationUtil.serializeObject((Object)event);
                    out.writeInt(binaryJobEvent.length);
                    out.write(binaryJobEvent);
                    HashMap<OperatorID, byte[]> operatorCoordinatorSnapshots = new HashMap<OperatorID, byte[]>();
                    for (Map.Entry<OperatorID, CompletableFuture<byte[]>> entry : event.getOperatorCoordinatorSnapshotFutures().entrySet()) {
                        operatorCoordinatorSnapshots.put(entry.getKey(), entry.getValue().get());
                    }
                    byte[] binaryOperatorCoordinatorSnapshots = InstantiationUtil.serializeObject(operatorCoordinatorSnapshots);
                    out.writeInt(binaryOperatorCoordinatorSnapshots.length);
                    out.write(binaryOperatorCoordinatorSnapshots);
                    if (event.getShuffleMasterSnapshotFuture() != null) {
                        byte[] binaryShuffleMasterSnapshot = InstantiationUtil.serializeObject((Object)event.getShuffleMasterSnapshotFuture().get());
                        out.writeInt(binaryShuffleMasterSnapshot.length);
                        out.write(binaryShuffleMasterSnapshot);
                    } else {
                        out.writeInt(0);
                    }
                    out.flush();
                    byArray = byteArrayOutputStream.toByteArray();
                }
                return byArray;
            }
            catch (Exception exception) {
                throw new IOException("Serialize ExecutionVertexFinishedEvent " + String.valueOf(event) + " failed.", exception);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public JobEvent deserialize(int version, byte[] bytes) throws IOException {
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
                ExecutionVertexFinishedEvent executionVertexFinishedEvent;
                try (DataInputViewStreamWrapper in = new DataInputViewStreamWrapper((InputStream)byteArrayInputStream);){
                    int binaryJobEventSize = in.readInt();
                    byte[] binaryJobEvent = Serializer.readBytes((DataInputStream)in, binaryJobEventSize);
                    ExecutionVertexFinishedEvent jobEvent = (ExecutionVertexFinishedEvent)InstantiationUtil.deserializeObject((byte[])binaryJobEvent, (ClassLoader)ClassLoader.getSystemClassLoader());
                    int binaryOperatorCoordinatorSnapshotsSize = in.readInt();
                    byte[] binaryOperatorCoordinatorSnapshots = Serializer.readBytes((DataInputStream)in, binaryOperatorCoordinatorSnapshotsSize);
                    Map operatorCoordinatorSnapshots = (Map)InstantiationUtil.deserializeObject((byte[])binaryOperatorCoordinatorSnapshots, (ClassLoader)ClassLoader.getSystemClassLoader());
                    jobEvent.operatorCoordinatorSnapshotFutures = new HashMap<OperatorID, CompletableFuture<byte[]>>();
                    operatorCoordinatorSnapshots.forEach((key, value) -> jobEvent.operatorCoordinatorSnapshotFutures.put((OperatorID)((Object)key), CompletableFuture.completedFuture(value)));
                    int binaryShuffleMasterSnapshotSize = in.readInt();
                    if (binaryShuffleMasterSnapshotSize > 0) {
                        byte[] binaryShuffleMasterSnapshot = Serializer.readBytes((DataInputStream)in, binaryShuffleMasterSnapshotSize);
                        jobEvent.shuffleMasterSnapshotFuture = CompletableFuture.completedFuture((ShuffleMasterSnapshot)InstantiationUtil.deserializeObject((byte[])binaryShuffleMasterSnapshot, (ClassLoader)ClassLoader.getSystemClassLoader()));
                    } else {
                        jobEvent.shuffleMasterSnapshotFuture = null;
                    }
                    executionVertexFinishedEvent = jobEvent;
                }
                return executionVertexFinishedEvent;
            }
            catch (Exception exception) {
                throw new IOException("Deserialize ExecutionVertexFinishedEvent failed.", exception);
            }
        }

        private static byte[] readBytes(DataInputStream in, int size) throws IOException {
            byte[] bytes = new byte[size];
            in.readFully(bytes);
            return bytes;
        }
    }
}

