/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.jobmanager.JobManagerProcessSpec;
import org.apache.flink.runtime.util.config.memory.CommonProcessMemorySpec;
import org.apache.flink.runtime.util.config.memory.JvmMetaspaceAndOverheadOptions;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryOptions;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtils;
import org.apache.flink.runtime.util.config.memory.jobmanager.JobManagerFlinkMemory;
import org.apache.flink.runtime.util.config.memory.jobmanager.JobManagerFlinkMemoryUtils;

public class JobManagerProcessUtils {
    static final ProcessMemoryOptions JM_PROCESS_MEMORY_OPTIONS = new ProcessMemoryOptions(Collections.singletonList(JobManagerOptions.JVM_HEAP_MEMORY), (ConfigOption<MemorySize>)JobManagerOptions.TOTAL_FLINK_MEMORY, (ConfigOption<MemorySize>)JobManagerOptions.TOTAL_PROCESS_MEMORY, new JvmMetaspaceAndOverheadOptions((ConfigOption<MemorySize>)JobManagerOptions.JVM_METASPACE, (ConfigOption<MemorySize>)JobManagerOptions.JVM_OVERHEAD_MIN, (ConfigOption<MemorySize>)JobManagerOptions.JVM_OVERHEAD_MAX, (ConfigOption<Float>)JobManagerOptions.JVM_OVERHEAD_FRACTION));
    private static final ProcessMemoryUtils<JobManagerFlinkMemory> PROCESS_MEMORY_UTILS = new ProcessMemoryUtils<JobManagerFlinkMemory>(JM_PROCESS_MEMORY_OPTIONS, new JobManagerFlinkMemoryUtils());

    private JobManagerProcessUtils() {
    }

    public static JobManagerProcessSpec processSpecFromConfig(Configuration config) {
        return JobManagerProcessUtils.createMemoryProcessSpec(PROCESS_MEMORY_UTILS.memoryProcessSpecFromConfig(config));
    }

    private static JobManagerProcessSpec createMemoryProcessSpec(CommonProcessMemorySpec<JobManagerFlinkMemory> processMemory) {
        return new JobManagerProcessSpec(processMemory.getFlinkMemory(), processMemory.getJvmMetaspaceAndOverhead());
    }

    @VisibleForTesting
    public static JobManagerProcessSpec createDefaultJobManagerProcessSpec(int totalProcessMemoryMb) {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.TOTAL_PROCESS_MEMORY, (Object)MemorySize.ofMebiBytes((long)totalProcessMemoryMb));
        return JobManagerProcessUtils.processSpecFromConfig(configuration);
    }

    public static String generateJvmParametersStr(JobManagerProcessSpec processSpec, Configuration configuration) {
        return ProcessMemoryUtils.generateJvmParametersStr(processSpec, (Boolean)configuration.get(JobManagerOptions.JVM_DIRECT_MEMORY_LIMIT_ENABLED));
    }

    public static String generateDynamicConfigsStr(JobManagerProcessSpec jobManagerProcessSpec) {
        HashMap<String, CallSite> config = new HashMap<String, CallSite>();
        config.put(JobManagerOptions.JVM_HEAP_MEMORY.key(), (CallSite)((Object)(jobManagerProcessSpec.getJvmHeapMemorySize().getBytes() + "b")));
        config.put(JobManagerOptions.OFF_HEAP_MEMORY.key(), (CallSite)((Object)(jobManagerProcessSpec.getJvmDirectMemorySize().getBytes() + "b")));
        config.put(JobManagerOptions.JVM_METASPACE.key(), (CallSite)((Object)(jobManagerProcessSpec.getJvmMetaspaceSize().getBytes() + "b")));
        config.put(JobManagerOptions.JVM_OVERHEAD_MIN.key(), (CallSite)((Object)(jobManagerProcessSpec.getJvmOverheadSize().getBytes() + "b")));
        config.put(JobManagerOptions.JVM_OVERHEAD_MAX.key(), (CallSite)((Object)(jobManagerProcessSpec.getJvmOverheadSize().getBytes() + "b")));
        return ConfigurationUtils.assembleDynamicConfigsStr(config);
    }
}

