/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.checkpoint.filemerging.PhysicalFile;
import org.apache.flink.runtime.state.CheckpointedStateScope;

public abstract class PhysicalFilePool
implements Closeable {
    protected final PhysicalFile.PhysicalFileCreator physicalFileCreator;
    protected final long maxFileSize;
    protected final Map<FileMergingSnapshotManager.SubtaskKey, Queue<PhysicalFile>> sharedPhysicalFilePoolBySubtask;
    protected final Queue<PhysicalFile> exclusivePhysicalFilePool;

    public PhysicalFilePool(long maxFileSize, PhysicalFile.PhysicalFileCreator physicalFileCreator) {
        this.physicalFileCreator = physicalFileCreator;
        this.maxFileSize = maxFileSize;
        this.sharedPhysicalFilePoolBySubtask = new ConcurrentHashMap<FileMergingSnapshotManager.SubtaskKey, Queue<PhysicalFile>>();
        this.exclusivePhysicalFilePool = this.createFileQueue();
    }

    public abstract boolean tryPutFile(FileMergingSnapshotManager.SubtaskKey var1, PhysicalFile var2) throws IOException;

    @Nonnull
    public abstract PhysicalFile pollFile(FileMergingSnapshotManager.SubtaskKey var1, CheckpointedStateScope var2) throws IOException;

    protected abstract Queue<PhysicalFile> createFileQueue();

    protected Queue<PhysicalFile> getFileQueue(FileMergingSnapshotManager.SubtaskKey subtaskKey, CheckpointedStateScope scope) {
        return CheckpointedStateScope.SHARED.equals((Object)scope) ? this.sharedPhysicalFilePoolBySubtask.computeIfAbsent(subtaskKey, key -> this.createFileQueue()) : this.exclusivePhysicalFilePool;
    }

    public boolean isEmpty() {
        return this.sharedPhysicalFilePoolBySubtask.isEmpty() && this.exclusivePhysicalFilePool.isEmpty();
    }

    public void close(FileMergingSnapshotManager.SubtaskKey subtaskKey) throws IOException {
        if (this.sharedPhysicalFilePoolBySubtask.containsKey(subtaskKey)) {
            this.closeFilesInQueue(this.sharedPhysicalFilePoolBySubtask.remove(subtaskKey));
        }
        this.closeFilesInQueue(this.exclusivePhysicalFilePool);
    }

    @Override
    public void close() throws IOException {
        this.closeFilesInQueue(this.exclusivePhysicalFilePool);
        for (Queue<PhysicalFile> queue : this.sharedPhysicalFilePoolBySubtask.values()) {
            this.closeFilesInQueue(queue);
        }
        this.sharedPhysicalFilePoolBySubtask.clear();
    }

    private void closeFilesInQueue(Queue<PhysicalFile> queue) throws IOException {
        while (!queue.isEmpty()) {
            PhysicalFile physicalFile = queue.poll();
            if (physicalFile == null) continue;
            physicalFile.close();
        }
    }

    public static enum Type {
        BLOCKING,
        NON_BLOCKING;

    }
}

