/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.broadcast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.runtime.broadcast.BroadcastVariableKey;
import org.apache.flink.runtime.broadcast.InitializationTypeConflictException;
import org.apache.flink.runtime.broadcast.MaterializationExpiredException;
import org.apache.flink.runtime.io.network.api.reader.MutableReader;
import org.apache.flink.runtime.operators.BatchTask;
import org.apache.flink.runtime.operators.util.ReaderIterator;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastVariableMaterialization<T, C> {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastVariableMaterialization.class);
    private final Set<BatchTask<?, ?>> references = new HashSet();
    private final Object materializationMonitor = new Object();
    private final BroadcastVariableKey key;
    private ArrayList<T> data;
    private C transformed;
    private boolean materialized;
    private boolean disposed;

    public BroadcastVariableMaterialization(BroadcastVariableKey key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void materializeVariable(MutableReader<?> reader, TypeSerializerFactory<?> serializerFactory, BatchTask<?, ?> referenceHolder) throws MaterializationExpiredException, IOException {
        block21: {
            boolean materializer;
            Preconditions.checkNotNull(reader);
            Preconditions.checkNotNull(serializerFactory);
            Preconditions.checkNotNull(referenceHolder);
            Set<BatchTask<?, ?>> set = this.references;
            synchronized (set) {
                if (this.disposed) {
                    throw new MaterializationExpiredException();
                }
                if (!this.references.add(referenceHolder)) {
                    throw new IllegalStateException(String.format("The task %s already holds a reference to the broadcast variable %s.", referenceHolder.getEnvironment().getTaskInfo().getTaskNameWithSubtasks(), this.key.toString()));
                }
                materializer = this.references.size() == 1;
            }
            try {
                MutableReader typedReader = reader;
                TypeSerializer serializer = serializerFactory.getSerializer();
                ReaderIterator<Object> readerIterator = new ReaderIterator<Object>(typedReader, serializer);
                if (materializer) {
                    Object element;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Getting Broadcast Variable (" + String.valueOf(this.key) + ") - First access, materializing.");
                    }
                    ArrayList data = new ArrayList();
                    while ((element = readerIterator.next()) != null) {
                        data.add(element);
                    }
                    Object object = this.materializationMonitor;
                    synchronized (object) {
                        this.data = data;
                        this.materialized = true;
                        this.materializationMonitor.notifyAll();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Materialization of Broadcast Variable (" + String.valueOf(this.key) + ") finished.");
                    }
                    break block21;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Getting Broadcast Variable (" + String.valueOf(this.key) + ") - shared access.");
                }
                Object element = serializer.createInstance();
                while ((element = readerIterator.next(element)) != null) {
                }
                Object object = this.materializationMonitor;
                synchronized (object) {
                    while (!this.materialized && !this.disposed) {
                        this.materializationMonitor.wait();
                    }
                }
            }
            catch (Throwable t) {
                this.decrementReferenceIfHeld(referenceHolder);
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new IOException("Materialization of the broadcast variable failed.", t);
            }
        }
    }

    public boolean decrementReference(BatchTask<?, ?> referenceHolder) {
        return this.decrementReferenceInternal(referenceHolder, true);
    }

    public boolean decrementReferenceIfHeld(BatchTask<?, ?> referenceHolder) {
        return this.decrementReferenceInternal(referenceHolder, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decrementReferenceInternal(BatchTask<?, ?> referenceHolder, boolean errorIfNoReference) {
        Set<BatchTask<?, ?>> set = this.references;
        synchronized (set) {
            if (this.disposed || this.references.isEmpty()) {
                if (errorIfNoReference) {
                    throw new IllegalStateException("Decrementing reference to broadcast variable that is no longer alive.");
                }
                return false;
            }
            if (!this.references.remove(referenceHolder)) {
                if (errorIfNoReference) {
                    throw new IllegalStateException(String.format("The task %s did not hold a reference to the broadcast variable %s.", referenceHolder.getEnvironment().getTaskInfo().getTaskNameWithSubtasks(), this.key.toString()));
                }
                return false;
            }
            if (this.references.isEmpty()) {
                this.disposed = true;
                this.data = null;
                this.transformed = null;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getVariable() throws InitializationTypeConflictException {
        if (!this.materialized) {
            throw new IllegalStateException("The Broadcast Variable has not yet been materialized.");
        }
        if (this.disposed) {
            throw new IllegalStateException("The Broadcast Variable has been disposed");
        }
        Set<BatchTask<?, ?>> set = this.references;
        synchronized (set) {
            if (this.transformed != null) {
                if (this.transformed instanceof List) {
                    List casted = (List)this.transformed;
                    return casted;
                }
                throw new InitializationTypeConflictException(this.transformed.getClass());
            }
            return this.data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C getVariable(BroadcastVariableInitializer<T, C> initializer) {
        if (!this.materialized) {
            throw new IllegalStateException("The Broadcast Variable has not yet been materialized.");
        }
        if (this.disposed) {
            throw new IllegalStateException("The Broadcast Variable has been disposed");
        }
        Set<BatchTask<?, ?>> set = this.references;
        synchronized (set) {
            if (this.transformed == null) {
                this.transformed = initializer.initializeBroadcastVariable(this.data);
                this.data = null;
            }
            return this.transformed;
        }
    }
}

