/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import org.apache.flink.core.asyncprocessing.AsyncFutureImpl;
import org.apache.flink.runtime.asyncprocessing.RecordContext;

public class ContextAsyncFutureImpl<T>
extends AsyncFutureImpl<T> {
    private final RecordContext<?> recordContext;

    ContextAsyncFutureImpl(AsyncFutureImpl.CallbackRunner callbackRunner, AsyncFutureImpl.AsyncFrameworkExceptionHandler exceptionHandler, RecordContext<?> recordContext) {
        super(callbackRunner, exceptionHandler);
        this.recordContext = recordContext;
        recordContext.retain();
    }

    public <A> AsyncFutureImpl<A> makeNewFuture() {
        return new ContextAsyncFutureImpl<T>(this.callbackRunner, this.exceptionHandler, this.recordContext);
    }

    public void callbackRegistered() {
        this.recordContext.retain();
    }

    public void postComplete(boolean inCallbackRunner) {
        if (inCallbackRunner) {
            this.recordContext.release(Runnable::run);
        } else {
            this.recordContext.release(runnable -> {
                try {
                    this.callbackRunner.submit(runnable::run);
                }
                catch (Exception e) {
                    this.exceptionHandler.handleException("Caught exception when post complete StateFuture.", (Throwable)e);
                }
            });
        }
    }

    public void callbackFinished() {
        this.recordContext.release(Runnable::run);
    }
}

