/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.util.Preconditions;

public class KeyedOneInputStreamOperatorTestHarness<K, IN, OUT>
extends OneInputStreamOperatorTestHarness<IN, OUT> {
    public KeyedOneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, KeySelector<IN, K> keySelector, TypeInformation<K> keyType, int maxParallelism, int numSubtasks, int subtaskIndex) throws Exception {
        this((StreamOperatorFactory<OUT>)SimpleOperatorFactory.of(operator), keySelector, keyType, maxParallelism, numSubtasks, subtaskIndex);
    }

    public KeyedOneInputStreamOperatorTestHarness(StreamOperatorFactory<OUT> operatorFactory, KeySelector<IN, K> keySelector, TypeInformation<K> keyType, int maxParallelism, int numSubtasks, int subtaskIndex) throws Exception {
        super(operatorFactory, maxParallelism, numSubtasks, subtaskIndex);
        ClosureCleaner.clean(keySelector, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)false);
        this.config.setStatePartitioner(0, keySelector);
        this.config.setStateKeySerializer(keyType.createSerializer(this.executionConfig.getSerializerConfig()));
        this.config.serializeAllConfigs();
    }

    public KeyedOneInputStreamOperatorTestHarness(StreamOperatorFactory<OUT> operatorFactory, KeySelector<IN, K> keySelector, TypeInformation<K> keyType, TypeSerializer<IN> typeSerializerIn) throws Exception {
        super(operatorFactory, 1, 1, 0);
        ClosureCleaner.clean(keySelector, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)false);
        this.config.setStatePartitioner(0, keySelector);
        this.config.setupNetworkInputs(new TypeSerializer[]{(TypeSerializer)Preconditions.checkNotNull(typeSerializerIn)});
        this.config.setStateKeySerializer(keyType.createSerializer(this.executionConfig.getSerializerConfig()));
        this.config.serializeAllConfigs();
    }

    public KeyedOneInputStreamOperatorTestHarness(StreamOperatorFactory<OUT> operatorFactory, KeySelector<IN, K> keySelector, TypeInformation<K> keyType) throws Exception {
        this(operatorFactory, keySelector, keyType, 1, 1, 0);
    }

    public KeyedOneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, KeySelector<IN, K> keySelector, TypeInformation<K> keyType) throws Exception {
        this(operator, keySelector, keyType, 1, 1, 0);
    }

    public KeyedOneInputStreamOperatorTestHarness(OneInputStreamOperator<IN, OUT> operator, KeySelector<IN, K> keySelector, TypeInformation<K> keyType, MockEnvironment environment) throws Exception {
        super(operator, environment);
        ClosureCleaner.clean(keySelector, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)false);
        this.config.setStatePartitioner(0, keySelector);
        this.config.setStateKeySerializer(keyType.createSerializer(this.executionConfig.getSerializerConfig()));
        this.config.serializeAllConfigs();
    }

    public int numKeyedStateEntries() {
        AbstractStreamOperator abstractStreamOperator = (AbstractStreamOperator)this.operator;
        KeyedStateBackend keyedStateBackend = abstractStreamOperator.getKeyedStateBackend();
        if (keyedStateBackend instanceof HeapKeyedStateBackend) {
            return ((HeapKeyedStateBackend)keyedStateBackend).numKeyValueStateEntries();
        }
        throw new UnsupportedOperationException();
    }

    public <N> int numKeyedStateEntries(N namespace) {
        AbstractStreamOperator abstractStreamOperator = (AbstractStreamOperator)this.operator;
        KeyedStateBackend keyedStateBackend = abstractStreamOperator.getKeyedStateBackend();
        if (keyedStateBackend instanceof HeapKeyedStateBackend) {
            return ((HeapKeyedStateBackend)keyedStateBackend).numKeyValueStateEntries(namespace);
        }
        throw new UnsupportedOperationException();
    }
}

