/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.shaded.guava33.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ResourceCounterTest {
    private ResourceProfile resourceProfile1 = ResourceProfile.newBuilder().setManagedMemoryMB(42).build();
    private ResourceProfile resourceProfile2 = ResourceProfile.newBuilder().setCpuCores(1.7).build();

    ResourceCounterTest() {
    }

    @Test
    void testIsEmpty() {
        ResourceCounter empty = ResourceCounter.empty();
        Assertions.assertThat((boolean)empty.isEmpty()).isTrue();
    }

    @Test
    public void testWithResourceRejectsNegativeCount() {
        Assertions.assertThatThrownBy(() -> ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)-1)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testWithResourceCreatesEmptyCounterIfCountIsZero() {
        ResourceCounter empty = ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)0);
        Assertions.assertThat((boolean)empty.isEmpty()).isTrue();
    }

    @Test
    void testIsNonEmpty() {
        ResourceCounter resourceCounter = ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)1);
        Assertions.assertThat((boolean)resourceCounter.isEmpty()).isFalse();
        Assertions.assertThat((boolean)resourceCounter.containsResource(ResourceProfile.UNKNOWN)).isTrue();
    }

    @Test
    void testGetResourceCount() {
        Map<ResourceProfile, Integer> resources = this.createResources();
        ResourceCounter resourceCounter = ResourceCounter.withResources(resources);
        for (Map.Entry<ResourceProfile, Integer> resource : resources.entrySet()) {
            Assertions.assertThat((int)resourceCounter.getResourceCount(resource.getKey())).isEqualTo((Object)resource.getValue());
        }
    }

    @Test
    void testGetResourceCountReturnsZeroForUnknownResourceProfile() {
        ResourceCounter resourceCounter = ResourceCounter.withResources(this.createResources());
        Assertions.assertThat((int)resourceCounter.getResourceCount(ResourceProfile.newBuilder().build())).isZero();
    }

    @Test
    void testGetTotalResourceCount() {
        Map<ResourceProfile, Integer> resources = this.createResources();
        ResourceCounter resourceCounter = ResourceCounter.withResources(resources);
        Assertions.assertThat((int)resourceCounter.getTotalResourceCount()).isEqualTo(5);
    }

    @Test
    void testGetResources() {
        Map<ResourceProfile, Integer> resources = this.createResources();
        ResourceCounter resourceCounter = ResourceCounter.withResources(resources);
        Assertions.assertThat((Collection)resourceCounter.getResources()).containsExactlyInAnyOrderElementsOf(resources.keySet());
    }

    @Test
    void testGetResourceWithCount() {
        Map<ResourceProfile, Integer> resources = this.createResources();
        ResourceCounter resourceCounter = ResourceCounter.withResources(resources);
        Assertions.assertThat((Collection)resourceCounter.getResourcesWithCount()).containsExactlyInAnyOrderElementsOf(resources.entrySet());
    }

    @Test
    void testAddSameResourceProfile() {
        boolean value1 = true;
        int value2 = 42;
        ResourceCounter resourceCounter1 = ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)1);
        ResourceCounter resourceCounter2 = ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)42);
        ResourceCounter result = resourceCounter1.add(resourceCounter2);
        Assertions.assertThat((Collection)resourceCounter1.getResourcesWithCount()).containsExactlyInAnyOrderElementsOf(Collections.singletonMap(ResourceProfile.UNKNOWN, 1).entrySet());
        Assertions.assertThat((Collection)resourceCounter2.getResourcesWithCount()).containsExactlyInAnyOrderElementsOf(Collections.singletonMap(ResourceProfile.UNKNOWN, 42).entrySet());
        Assertions.assertThat((Collection)result.getResourcesWithCount()).containsExactlyInAnyOrderElementsOf(Collections.singletonMap(ResourceProfile.UNKNOWN, 43).entrySet());
    }

    @Test
    void testAddDifferentResourceProfile() {
        ResourceCounter resourceCounter1 = ResourceCounter.withResource((ResourceProfile)this.resourceProfile1, (int)1);
        ResourceCounter resourceCounter2 = ResourceCounter.withResource((ResourceProfile)this.resourceProfile2, (int)1);
        ResourceCounter result = resourceCounter1.add(resourceCounter2);
        ArrayList expectedResult = new ArrayList(resourceCounter1.getResourcesWithCount());
        expectedResult.addAll(resourceCounter2.getResourcesWithCount());
        Assertions.assertThat((Collection)result.getResourcesWithCount()).containsExactlyInAnyOrderElementsOf(expectedResult);
    }

    @Test
    void testCountEqualToZeroRemovesResource() {
        ResourceCounter resourceCounter = ResourceCounter.withResource((ResourceProfile)this.resourceProfile1, (int)2);
        ResourceCounter result = resourceCounter.subtract(this.resourceProfile1, 2);
        Assertions.assertThat((boolean)result.isEmpty()).isTrue();
    }

    @Test
    void testCountBelowZeroRemovesResources() {
        ResourceCounter resourceCounter = ResourceCounter.withResource((ResourceProfile)this.resourceProfile1, (int)1);
        ResourceCounter result = resourceCounter.subtract(this.resourceProfile1, 2);
        Assertions.assertThat((boolean)result.isEmpty()).isTrue();
    }

    @Test
    void testSubtractSameResourceProfile() {
        int value1 = 5;
        int value2 = 3;
        ResourceCounter resourceCounter1 = ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)5);
        ResourceCounter resourceCounter2 = ResourceCounter.withResource((ResourceProfile)ResourceProfile.UNKNOWN, (int)3);
        ResourceCounter result = resourceCounter1.subtract(resourceCounter2);
        Assertions.assertThat((Collection)resourceCounter1.getResourcesWithCount()).containsExactlyInAnyOrderElementsOf(Collections.singletonMap(ResourceProfile.UNKNOWN, 5).entrySet());
        Assertions.assertThat((Collection)resourceCounter2.getResourcesWithCount()).containsExactlyInAnyOrderElementsOf(Collections.singletonMap(ResourceProfile.UNKNOWN, 3).entrySet());
        Assertions.assertThat((Collection)result.getResourcesWithCount()).containsExactlyInAnyOrderElementsOf(Collections.singletonMap(ResourceProfile.UNKNOWN, 2).entrySet());
    }

    @Test
    void testSubtractDifferentResourceProfile() {
        ResourceCounter resourceCounter1 = ResourceCounter.withResource((ResourceProfile)this.resourceProfile1, (int)1);
        ResourceCounter resourceCounter2 = ResourceCounter.withResource((ResourceProfile)this.resourceProfile2, (int)1);
        ResourceCounter result = resourceCounter1.subtract(resourceCounter2);
        Assertions.assertThat((Collection)result.getResourcesWithCount()).containsExactlyInAnyOrderElementsOf((Iterable)resourceCounter1.getResourcesWithCount());
    }

    private Map<ResourceProfile, Integer> createResources() {
        return ImmutableMap.of((Object)this.resourceProfile1, (Object)2, (Object)this.resourceProfile2, (Object)3);
    }
}

