/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testtasks;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.util.Preconditions;

public class OnceBlockingNoOpInvokable
extends AbstractInvokable {
    private static final Map<ExecutionAttemptID, CountDownLatch> EXECUTION_LATCHES = new ConcurrentHashMap<ExecutionAttemptID, CountDownLatch>();
    private static volatile boolean isBlocking = true;
    private final ExecutionAttemptID executionAttemptId;

    public OnceBlockingNoOpInvokable(Environment environment) {
        super(environment);
        this.executionAttemptId = environment.getExecutionId();
        Preconditions.checkState((EXECUTION_LATCHES.put(this.executionAttemptId, new CountDownLatch(1)) == null ? 1 : 0) != 0);
    }

    public void invoke() throws Exception {
        CountDownLatch executionLatch = (CountDownLatch)Preconditions.checkNotNull((Object)EXECUTION_LATCHES.get(this.executionAttemptId));
        while (isBlocking && executionLatch.getCount() > 0L) {
            executionLatch.await();
        }
    }

    public void cancel() throws Exception {
        ((CountDownLatch)Preconditions.checkNotNull((Object)EXECUTION_LATCHES.get(this.executionAttemptId))).countDown();
    }

    public static void unblock() {
        isBlocking = false;
        EXECUTION_LATCHES.values().forEach(CountDownLatch::countDown);
    }

    public static void reset() {
        isBlocking = true;
        EXECUTION_LATCHES.clear();
    }
}

