/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.checkpoints;

import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatsCache;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CheckpointStatsCacheTest {
    CheckpointStatsCacheTest() {
    }

    @Test
    void testZeroSizeCache() throws Exception {
        AbstractCheckpointStats checkpoint = this.createCheckpoint(0L, CheckpointStatsStatus.COMPLETED);
        CheckpointStatsCache cache = new CheckpointStatsCache(0);
        cache.tryAdd(checkpoint);
        Assertions.assertThat((Object)cache.tryGet(0L)).isNull();
    }

    @Test
    void testCacheAddAndGet() throws Exception {
        AbstractCheckpointStats chk0 = this.createCheckpoint(0L, CheckpointStatsStatus.COMPLETED);
        AbstractCheckpointStats chk1 = this.createCheckpoint(1L, CheckpointStatsStatus.COMPLETED);
        AbstractCheckpointStats chk2 = this.createCheckpoint(2L, CheckpointStatsStatus.IN_PROGRESS);
        CheckpointStatsCache cache = new CheckpointStatsCache(1);
        cache.tryAdd(chk0);
        Assertions.assertThat((Object)cache.tryGet(0L)).isEqualTo((Object)chk0);
        cache.tryAdd(chk1);
        Assertions.assertThat((Object)cache.tryGet(0L)).isNull();
        Assertions.assertThat((Object)cache.tryGet(1L)).isEqualTo((Object)chk1);
        cache.tryAdd(chk2);
        Assertions.assertThat((Object)cache.tryGet(2L)).isNull();
        Assertions.assertThat((Object)cache.tryGet(0L)).isNull();
        Assertions.assertThat((Object)cache.tryGet(1L)).isEqualTo((Object)chk1);
    }

    private AbstractCheckpointStats createCheckpoint(long id, CheckpointStatsStatus status) {
        AbstractCheckpointStats checkpoint = (AbstractCheckpointStats)Mockito.mock(AbstractCheckpointStats.class);
        Mockito.when((Object)checkpoint.getCheckpointId()).thenReturn((Object)id);
        Mockito.when((Object)checkpoint.getStatus()).thenReturn((Object)status);
        return checkpoint;
    }
}

