/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.JobDetailsHandler;
import org.apache.flink.runtime.rest.handler.legacy.DefaultExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcherImpl;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionConfigBuilder;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobPlanInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.JobDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.JobDetailsInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class JobDetailsHandlerTest {
    private JobDetailsHandler jobDetailsHandler;
    private HandlerRequest<EmptyRequestBody> handlerRequest;
    private AccessExecutionGraph archivedExecutionGraph;
    private final String expectedStreamGraphJson = "{\"pending_operators:2,\":\"nodes\":[{\"id\":\"1\",\"parallelism\":1,\"operator\":\"Source: Sequence Source\",\"description\":\"Source: Sequence Source\",\"inputs\":[]},{\"id\":\"2\",\"parallelism\":1,\"operator\":\"Sink: Print to Std. Out\",\"description\":\"Sink: Print to Std. Out\",\"inputs\":[{\"num\":0,\"id\":\"1\",\"ship_strategy\":\"FORWARD\",\"exchange\":\"UNDEFINED\"}]}]}";

    JobDetailsHandlerTest() {
    }

    private static HandlerRequest<EmptyRequestBody> createRequest(JobID jobId) throws HandlerRequestException {
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put("jobid", jobId.toString());
        return HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TaskManagerMessageParameters(), pathParameters, Collections.emptyMap(), Collections.emptyList());
    }

    @BeforeEach
    void setUp() throws HandlerRequestException {
        GatewayRetriever leaderRetriever = () -> CompletableFuture.completedFuture(null);
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)new Configuration());
        MetricFetcherImpl metricFetcher = new MetricFetcherImpl(() -> null, address -> null, Executors.directExecutor(), Duration.ofMillis(1000L), ((Duration)MetricOptions.METRIC_FETCHER_UPDATE_INTERVAL.defaultValue()).toMillis());
        ArchivedExecutionConfig archivedExecutionConfig = new ArchivedExecutionConfigBuilder().build();
        this.archivedExecutionGraph = new ArchivedExecutionGraphBuilder().setArchivedExecutionConfig(archivedExecutionConfig).setStreamGraphJson("{\"pending_operators:2,\":\"nodes\":[{\"id\":\"1\",\"parallelism\":1,\"operator\":\"Source: Sequence Source\",\"description\":\"Source: Sequence Source\",\"inputs\":[]},{\"id\":\"2\",\"parallelism\":1,\"operator\":\"Sink: Print to Std. Out\",\"description\":\"Sink: Print to Std. Out\",\"inputs\":[{\"num\":0,\"id\":\"1\",\"ship_strategy\":\"FORWARD\",\"exchange\":\"UNDEFINED\"}]}]}").build();
        this.jobDetailsHandler = new JobDetailsHandler(leaderRetriever, TestingUtils.TIMEOUT, Collections.emptyMap(), (MessageHeaders)JobDetailsHeaders.getInstance(), (ExecutionGraphCache)new DefaultExecutionGraphCache(restHandlerConfiguration.getTimeout(), Duration.ofMillis(restHandlerConfiguration.getRefreshInterval())), Executors.directExecutor(), (MetricFetcher)metricFetcher);
        this.handlerRequest = JobDetailsHandlerTest.createRequest(this.archivedExecutionGraph.getJobID());
    }

    @Test
    void testGetJobDetailsWithStreamGraphJson() throws RestHandlerException {
        JobDetailsInfo jobDetailsInfo = this.jobDetailsHandler.handleRequest(this.handlerRequest, this.archivedExecutionGraph);
        Assertions.assertThat((String)jobDetailsInfo.getStreamGraphJson()).isEqualTo(new JobPlanInfo.RawJson("{\"pending_operators:2,\":\"nodes\":[{\"id\":\"1\",\"parallelism\":1,\"operator\":\"Source: Sequence Source\",\"description\":\"Source: Sequence Source\",\"inputs\":[]},{\"id\":\"2\",\"parallelism\":1,\"operator\":\"Sink: Print to Std. Out\",\"description\":\"Sink: Print to Std. Out\",\"inputs\":[{\"num\":0,\"id\":\"1\",\"ship_strategy\":\"FORWARD\",\"exchange\":\"UNDEFINED\"}]}]}").toString());
    }
}

