/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.TestingTieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.TestingPartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.SubpartitionRemoteCacheManager;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SubpartitionRemoteCacheManagerTest {
    SubpartitionRemoteCacheManagerTest() {
    }

    @Test
    void testStartAndFinishSegment() {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        int subpartitionId = 0;
        int segmentId = 0;
        AtomicInteger numReceivedBuffers = new AtomicInteger(0);
        TestingPartitionFileWriter partitionFileWriter = new TestingPartitionFileWriter.Builder().setWriteFunction((ignoredPartitionId, bufferContexts) -> {
            numReceivedBuffers.addAndGet(((PartitionFileWriter.SegmentBufferContext)((PartitionFileWriter.SubpartitionBufferContext)bufferContexts.get(subpartitionId)).getSegmentBufferContexts().get(segmentId)).getBufferAndIndexes().size());
            return FutureUtils.completedVoidFuture();
        }).build();
        SubpartitionRemoteCacheManager cacheManager = new SubpartitionRemoteCacheManager(partitionId, subpartitionId, (TieredStorageMemoryManager)new TestingTieredStorageMemoryManager.Builder().build(), (PartitionFileWriter)partitionFileWriter);
        cacheManager.startSegment(segmentId);
        cacheManager.addBuffer(BufferBuilderTestUtils.buildSomeBuffer());
        cacheManager.finishSegment(segmentId);
        Assertions.assertThat((AtomicInteger)numReceivedBuffers).hasValue(1);
    }

    @Test
    void testStartSegmentWithUnFlushedBuffers() {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        int subpartitionId = 0;
        int firstSegmentId = 0;
        int secondSegmentId = 1;
        SubpartitionRemoteCacheManager cacheManager = new SubpartitionRemoteCacheManager(partitionId, subpartitionId, (TieredStorageMemoryManager)new TestingTieredStorageMemoryManager.Builder().build(), (PartitionFileWriter)new TestingPartitionFileWriter.Builder().build());
        cacheManager.startSegment(firstSegmentId);
        cacheManager.addBuffer(BufferBuilderTestUtils.buildSomeBuffer());
        Assertions.assertThatThrownBy(() -> cacheManager.startSegment(secondSegmentId)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testFinishWrongSegment() {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        int subpartitionId = 0;
        int segmentId = 0;
        SubpartitionRemoteCacheManager cacheManager = new SubpartitionRemoteCacheManager(partitionId, subpartitionId, (TieredStorageMemoryManager)new TestingTieredStorageMemoryManager.Builder().build(), (PartitionFileWriter)new TestingPartitionFileWriter.Builder().build());
        cacheManager.startSegment(segmentId);
        Assertions.assertThatThrownBy(() -> cacheManager.finishSegment(1)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testRecycleBuffers() {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        int subpartitionId = 0;
        int segmentId = 0;
        AtomicInteger numWrittenBuffers = new AtomicInteger(0);
        TestingPartitionFileWriter partitionFileWriter = new TestingPartitionFileWriter.Builder().setWriteFunction((ignore, bufferContexts) -> {
            for (PartitionFileWriter.SubpartitionBufferContext subpartitionBufferContext : bufferContexts) {
                for (PartitionFileWriter.SegmentBufferContext segmentBufferContext : subpartitionBufferContext.getSegmentBufferContexts()) {
                    numWrittenBuffers.getAndAdd(segmentBufferContext.getBufferAndIndexes().size());
                }
            }
            return FutureUtils.completedVoidFuture();
        }).build();
        SubpartitionRemoteCacheManager cacheManager = new SubpartitionRemoteCacheManager(partitionId, subpartitionId, (TieredStorageMemoryManager)new TestingTieredStorageMemoryManager.Builder().build(), (PartitionFileWriter)partitionFileWriter);
        NetworkBuffer buffer = new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)1), FreeingBufferRecycler.INSTANCE);
        cacheManager.startSegment(segmentId);
        cacheManager.addBuffer((Buffer)buffer);
        cacheManager.close();
        cacheManager.release();
        Assertions.assertThat((AtomicInteger)numWrittenBuffers).hasValue(1);
    }

    @Test
    void testClose() {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        int subpartitionId = 0;
        int segmentId = 0;
        AtomicInteger numReceivedBuffers = new AtomicInteger(0);
        TestingPartitionFileWriter partitionFileWriter = new TestingPartitionFileWriter.Builder().setWriteFunction((ignoredPartitionId, bufferContexts) -> {
            numReceivedBuffers.addAndGet(((PartitionFileWriter.SegmentBufferContext)((PartitionFileWriter.SubpartitionBufferContext)bufferContexts.get(subpartitionId)).getSegmentBufferContexts().get(segmentId)).getBufferAndIndexes().size());
            return FutureUtils.completedVoidFuture();
        }).build();
        SubpartitionRemoteCacheManager cacheManager = new SubpartitionRemoteCacheManager(partitionId, subpartitionId, (TieredStorageMemoryManager)new TestingTieredStorageMemoryManager.Builder().build(), (PartitionFileWriter)partitionFileWriter);
        cacheManager.startSegment(segmentId);
        cacheManager.addBuffer(BufferBuilderTestUtils.buildSomeBuffer());
        cacheManager.close();
        Assertions.assertThat((AtomicInteger)numReceivedBuffers).hasValue(1);
    }

    @Test
    void testClose_noSegmentHasStarted() {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        boolean subpartitionId = false;
        AtomicBoolean writeCalled = new AtomicBoolean(false);
        TestingPartitionFileWriter partitionFileWriter = new TestingPartitionFileWriter.Builder().setWriteFunction((ignoredPartitionId, bufferContexts) -> {
            writeCalled.set(true);
            return FutureUtils.completedVoidFuture();
        }).build();
        SubpartitionRemoteCacheManager cacheManager = new SubpartitionRemoteCacheManager(partitionId, 0, (TieredStorageMemoryManager)new TestingTieredStorageMemoryManager.Builder().build(), (PartitionFileWriter)partitionFileWriter);
        cacheManager.close();
        Assertions.assertThat((AtomicBoolean)writeCalled).isFalse();
    }

    @Test
    void testRelease() {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        int subpartitionId = 0;
        AtomicBoolean isReleased = new AtomicBoolean(false);
        TestingPartitionFileWriter partitionFileWriter = new TestingPartitionFileWriter.Builder().setReleaseRunnable(() -> isReleased.set(true)).build();
        SubpartitionRemoteCacheManager cacheManager = new SubpartitionRemoteCacheManager(partitionId, subpartitionId, (TieredStorageMemoryManager)new TestingTieredStorageMemoryManager.Builder().build(), (PartitionFileWriter)partitionFileWriter);
        cacheManager.release();
        Assertions.assertThat((AtomicBoolean)isReleased).isTrue();
    }
}

