/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.NoOpResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.UnionResultSubpartitionView;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class UnionResultSubpartitionViewTest {
    private UnionResultSubpartitionView view;
    private List<Buffer> buffers0;
    private ResultSubpartitionView view0;
    private List<Buffer> buffers1;
    private ResultSubpartitionView view1;

    UnionResultSubpartitionViewTest() {
    }

    @BeforeEach
    void before() {
        this.view = new UnionResultSubpartitionView(x -> {}, 2);
        this.buffers0 = Arrays.asList(TestBufferFactory.createBuffer(10), TestBufferFactory.createBuffer(10), TestBufferFactory.createBuffer(10, Buffer.DataType.EVENT_BUFFER));
        this.view0 = new TestingResultSubpartitionView((BufferAvailabilityListener)this.view, this.buffers0);
        this.view.notifyViewCreated(0, this.view0);
        this.buffers1 = Arrays.asList(TestBufferFactory.createBuffer(10), TestBufferFactory.createBuffer(10), TestBufferFactory.createBuffer(10, Buffer.DataType.EVENT_BUFFER));
        this.view1 = new TestingResultSubpartitionView((BufferAvailabilityListener)this.view, this.buffers1);
        this.view.notifyViewCreated(1, this.view1);
    }

    @Test
    void testGetNextBuffer() throws IOException {
        Assertions.assertThat((int)this.view.peekNextBufferSubpartitionId()).isEqualTo(-1);
        Assertions.assertThat((Object)this.view.getNextBuffer()).isNull();
        this.view0.notifyDataAvailable();
        Assertions.assertThat((int)this.view.peekNextBufferSubpartitionId()).isZero();
        ResultSubpartition.BufferAndBacklog bufferAndBacklog = this.view.getNextBuffer();
        Assertions.assertThat((Object)bufferAndBacklog.buffer()).isEqualTo((Object)this.buffers0.get(0));
        Assertions.assertThat((int)bufferAndBacklog.buffersInBacklog()).isEqualTo(this.buffers0.size() - 1);
        this.view1.notifyDataAvailable();
        Assertions.assertThat((int)this.view.peekNextBufferSubpartitionId()).isZero();
        Assertions.assertThat((Object)this.view.getNextBuffer().buffer()).isEqualTo((Object)this.buffers0.get(1));
        ArrayList<Buffer> buffers = new ArrayList<Buffer>();
        while (this.view.getAvailabilityAndBacklog(true).isAvailable()) {
            buffers.add(this.view.getNextBuffer().buffer());
        }
        ((ListAssert)((ListAssert)Assertions.assertThat(buffers).hasSize(this.buffers0.size() + this.buffers1.size() - 2)).containsSubsequence(this.buffers0.subList(2, this.buffers0.size()))).containsSubsequence(this.buffers1);
    }

    @Test
    void testGetAvailabilityAndBacklog() throws IOException {
        this.view0.notifyDataAvailable();
        this.view1.notifyDataAvailable();
        ResultSubpartitionView.AvailabilityWithBacklog availabilityAndBacklog1 = this.view.getAvailabilityAndBacklog(false);
        Assertions.assertThat((int)availabilityAndBacklog1.getBacklog()).isPositive();
        Assertions.assertThat((boolean)availabilityAndBacklog1.isAvailable()).isFalse();
        ResultSubpartitionView.AvailabilityWithBacklog availabilityAndBacklog2 = this.view.getAvailabilityAndBacklog(true);
        Assertions.assertThat((int)availabilityAndBacklog2.getBacklog()).isPositive();
        Assertions.assertThat((boolean)availabilityAndBacklog2.isAvailable()).isTrue();
        for (int i = 1; i < this.buffers0.size() + this.buffers1.size(); ++i) {
            this.view.getNextBuffer();
        }
        ResultSubpartitionView.AvailabilityWithBacklog availabilityAndBacklog3 = this.view.getAvailabilityAndBacklog(false);
        Assertions.assertThat((int)availabilityAndBacklog3.getBacklog()).isZero();
        Assertions.assertThat((boolean)availabilityAndBacklog3.isAvailable()).isTrue();
        ResultSubpartitionView.AvailabilityWithBacklog availabilityAndBacklog4 = this.view.getAvailabilityAndBacklog(true);
        Assertions.assertThat((int)availabilityAndBacklog4.getBacklog()).isZero();
        Assertions.assertThat((boolean)availabilityAndBacklog4.isAvailable()).isTrue();
    }

    @Test
    void testReleaseAllResources() throws IOException {
        Assertions.assertThat((boolean)this.view.isReleased()).isFalse();
        Assertions.assertThat((boolean)this.view0.isReleased()).isFalse();
        Assertions.assertThat((boolean)this.view1.isReleased()).isFalse();
        Assertions.assertThat(this.buffers0).allMatch(x -> !x.isRecycled());
        Assertions.assertThat(this.buffers1).allMatch(x -> !x.isRecycled());
        this.view0.notifyDataAvailable();
        this.view.releaseAllResources();
        Assertions.assertThat((boolean)this.view.isReleased()).isTrue();
        Assertions.assertThat((boolean)this.view0.isReleased()).isTrue();
        Assertions.assertThat((boolean)this.view1.isReleased()).isTrue();
        Assertions.assertThat(this.buffers0).allMatch(Buffer::isRecycled);
        Assertions.assertThat(this.buffers1).allMatch(Buffer::isRecycled);
    }

    @Test
    public void testDataAvailableBeforeRegistration() {
        TestAvailabilityListener listener = new TestAvailabilityListener();
        this.view = new UnionResultSubpartitionView((BufferAvailabilityListener)listener, 2);
        this.view0 = new TestingResultSubpartitionView((BufferAvailabilityListener)this.view, this.buffers0);
        this.view1 = new TestingResultSubpartitionView((BufferAvailabilityListener)this.view, this.buffers1);
        this.view0.notifyDataAvailable();
        Assertions.assertThat((boolean)listener.isDataAvailable()).isFalse();
        ResultSubpartitionView.AvailabilityWithBacklog availabilityAndBacklog1 = this.view.getAvailabilityAndBacklog(true);
        Assertions.assertThat((int)availabilityAndBacklog1.getBacklog()).isZero();
        Assertions.assertThat((boolean)availabilityAndBacklog1.isAvailable()).isFalse();
        this.view.notifyViewCreated(0, this.view0);
        Assertions.assertThat((boolean)listener.isDataAvailable()).isFalse();
        this.view.notifyViewCreated(1, this.view1);
        Assertions.assertThat((boolean)listener.isDataAvailable()).isTrue();
        ResultSubpartitionView.AvailabilityWithBacklog availabilityAndBacklog2 = this.view.getAvailabilityAndBacklog(true);
        Assertions.assertThat((int)availabilityAndBacklog2.getBacklog()).isPositive();
        Assertions.assertThat((boolean)availabilityAndBacklog2.isAvailable()).isTrue();
    }

    private static class TestAvailabilityListener
    implements BufferAvailabilityListener {
        private boolean isDataAvailable = false;

        private TestAvailabilityListener() {
        }

        public void notifyDataAvailable(ResultSubpartitionView view) {
            this.isDataAvailable = true;
        }

        boolean isDataAvailable() {
            return this.isDataAvailable;
        }
    }

    private static class TestingResultSubpartitionView
    extends NoOpResultSubpartitionView {
        private final BufferAvailabilityListener listener;
        private final List<Buffer> buffers;
        private int sequenceNumber = 0;
        private boolean isReleased = false;

        private TestingResultSubpartitionView(BufferAvailabilityListener listener, List<Buffer> buffers) {
            this.listener = listener;
            this.buffers = new ArrayList<Buffer>(buffers);
        }

        @Nullable
        public ResultSubpartition.BufferAndBacklog getNextBuffer() {
            if (this.buffers.isEmpty()) {
                return null;
            }
            Buffer buffer = this.buffers.remove(0);
            return new ResultSubpartition.BufferAndBacklog(buffer, this.buffers.size(), this.buffers.isEmpty() ? Buffer.DataType.NONE : this.buffers.get(0).getDataType(), this.sequenceNumber++);
        }

        public ResultSubpartitionView.AvailabilityWithBacklog getAvailabilityAndBacklog(boolean isCreditAvailable) {
            if (this.buffers.isEmpty()) {
                return new ResultSubpartitionView.AvailabilityWithBacklog(false, 0);
            }
            return new ResultSubpartitionView.AvailabilityWithBacklog(isCreditAvailable || this.buffers.get(0).getDataType().isEvent(), this.buffers.size());
        }

        public void notifyDataAvailable() {
            this.listener.notifyDataAvailable((ResultSubpartitionView)this);
        }

        public void releaseAllResources() {
            this.buffers.forEach(Buffer::recycleBuffer);
            this.buffers.clear();
            this.isReleased = true;
        }

        public boolean isReleased() {
            return this.isReleased;
        }
    }
}

