/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.ExternalResourceOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtilsTestBase;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableTypeAssert;
import org.junit.jupiter.api.Test;

class TaskExecutorProcessUtilsTest
extends ProcessMemoryUtilsTestBase<TaskExecutorProcessSpec> {
    private static final MemorySize TASK_HEAP_SIZE = MemorySize.parse((String)"100m");
    private static final MemorySize MANAGED_MEM_SIZE = MemorySize.parse((String)"200m");
    private static final MemorySize TOTAL_FLINK_MEM_SIZE = MemorySize.parse((String)"1280m");
    private static final MemorySize TOTAL_PROCESS_MEM_SIZE = MemorySize.parse((String)"1536m");
    private static final String EXTERNAL_RESOURCE_NAME_1 = "gpu";
    private static final String EXTERNAL_RESOURCE_NAME_2 = "custom";
    private static final TaskExecutorProcessSpec TM_RESOURCE_SPEC = new TaskExecutorProcessSpec(new CPUResource(1.0), MemorySize.parse((String)"1m"), MemorySize.parse((String)"2m"), MemorySize.parse((String)"3m"), MemorySize.parse((String)"4m"), MemorySize.parse((String)"5m"), MemorySize.parse((String)"6m"), MemorySize.parse((String)"7m"), MemorySize.parse((String)"8m"), Arrays.asList(new ExternalResource("gpu", 1.0), new ExternalResource("custom", 2.0)));

    public TaskExecutorProcessUtilsTest() {
        super(TaskExecutorProcessUtils.TM_PROCESS_MEMORY_OPTIONS, (ConfigOption<MemorySize>)TaskManagerOptions.TOTAL_PROCESS_MEMORY);
    }

    @Test
    void testGenerateDynamicConfigurations() {
        String dynamicConfigsStr = TaskExecutorProcessUtils.generateDynamicConfigsStr((TaskExecutorProcessSpec)TM_RESOURCE_SPEC);
        Map configs = ConfigurationUtils.parseTmResourceDynamicConfigs((String)dynamicConfigsStr);
        Assertions.assertThat((Comparable)new CPUResource(Double.parseDouble((String)configs.get(TaskManagerOptions.CPU_CORES.key())))).isEqualTo((Object)TM_RESOURCE_SPEC.getCpuCores());
        Assertions.assertThat((Comparable)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY.key())))).isEqualTo((Object)TM_RESOURCE_SPEC.getFrameworkHeapSize());
        Assertions.assertThat((Comparable)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY.key())))).isEqualTo((Object)TM_RESOURCE_SPEC.getFrameworkOffHeapMemorySize());
        Assertions.assertThat((Comparable)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.TASK_HEAP_MEMORY.key())))).isEqualTo((Object)TM_RESOURCE_SPEC.getTaskHeapSize());
        Assertions.assertThat((Comparable)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.TASK_OFF_HEAP_MEMORY.key())))).isEqualTo((Object)TM_RESOURCE_SPEC.getTaskOffHeapSize());
        Assertions.assertThat((Comparable)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.NETWORK_MEMORY_MAX.key())))).isEqualTo((Object)TM_RESOURCE_SPEC.getNetworkMemSize());
        Assertions.assertThat((Comparable)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.NETWORK_MEMORY_MIN.key())))).isEqualTo((Object)TM_RESOURCE_SPEC.getNetworkMemSize());
        Assertions.assertThat((Comparable)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.MANAGED_MEMORY_SIZE.key())))).isEqualTo((Object)TM_RESOURCE_SPEC.getManagedMemorySize());
        Assertions.assertThat((Comparable)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.JVM_METASPACE.key())))).isEqualTo((Object)TM_RESOURCE_SPEC.getJvmMetaspaceAndOverhead().getMetaspace());
        Assertions.assertThat((Comparable)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.JVM_OVERHEAD_MIN.key())))).isEqualTo((Object)TM_RESOURCE_SPEC.getJvmMetaspaceAndOverhead().getOverhead());
        Assertions.assertThat((Comparable)MemorySize.parse((String)((String)configs.get(TaskManagerOptions.JVM_OVERHEAD_MAX.key())))).isEqualTo((Object)TM_RESOURCE_SPEC.getJvmMetaspaceAndOverhead().getOverhead());
        Assertions.assertThat((Integer)Integer.valueOf((String)configs.get(TaskManagerOptions.NUM_TASK_SLOTS.key()))).isEqualTo(TM_RESOURCE_SPEC.getNumSlots());
        Assertions.assertThat((String)((String)configs.get(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST.key()))).isEqualTo("\"" + String.join((CharSequence)";", TM_RESOURCE_SPEC.getExtendedResources().keySet()) + "\"");
        Assertions.assertThat((String)((String)configs.get(ExternalResourceOptions.getAmountConfigOptionForResource((String)EXTERNAL_RESOURCE_NAME_1)))).isEqualTo(String.valueOf(((ExternalResource)TM_RESOURCE_SPEC.getExtendedResources().get(EXTERNAL_RESOURCE_NAME_1)).getValue().longValue()));
        Assertions.assertThat((String)((String)configs.get(ExternalResourceOptions.getAmountConfigOptionForResource((String)EXTERNAL_RESOURCE_NAME_2)))).isEqualTo(String.valueOf(((ExternalResource)TM_RESOURCE_SPEC.getExtendedResources().get(EXTERNAL_RESOURCE_NAME_2)).getValue().longValue()));
    }

    @Test
    void testProcessSpecFromWorkerResourceSpec() {
        WorkerResourceSpec workerResourceSpec = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(200).setNetworkMemoryMB(300).setManagedMemoryMB(400).setNumSlots(5).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME_1, 1.0)).build();
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromWorkerResourceSpec((Configuration)new Configuration(), (WorkerResourceSpec)workerResourceSpec);
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getCpuCores()).isEqualTo((Object)workerResourceSpec.getCpuCores());
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getTaskHeapSize()).isEqualTo((Object)workerResourceSpec.getTaskHeapSize());
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getTaskOffHeapSize()).isEqualTo((Object)workerResourceSpec.getTaskOffHeapSize());
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getNetworkMemSize()).isEqualTo((Object)workerResourceSpec.getNetworkMemSize());
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getManagedMemorySize()).isEqualTo((Object)workerResourceSpec.getManagedMemSize());
        Assertions.assertThat((int)taskExecutorProcessSpec.getNumSlots()).isEqualTo(workerResourceSpec.getNumSlots());
        Assertions.assertThat((Map)taskExecutorProcessSpec.getExtendedResources()).isEqualTo((Object)workerResourceSpec.getExtendedResources());
    }

    @Test
    void testConfigCpuCores() {
        double cpuCores = 1.0;
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.CPU_CORES, (Object)1.0);
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> Assertions.assertThat((Comparable)taskExecutorProcessSpec.getCpuCores()).isEqualTo((Object)new CPUResource(1.0)));
    }

    @Test
    void testConfigNoCpuCores() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.NUM_TASK_SLOTS, (Object)3);
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> Assertions.assertThat((Comparable)taskExecutorProcessSpec.getCpuCores()).isEqualTo((Object)new CPUResource(3.0)));
    }

    @Test
    void testConfigNegativeCpuCores() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.CPU_CORES, (Object)-0.1);
        this.validateFailInAllConfigurations(conf);
    }

    @Test
    void testConfigFrameworkHeapMemory() {
        MemorySize frameworkHeapSize = MemorySize.parse((String)"100m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, (Object)frameworkHeapSize);
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> Assertions.assertThat((Comparable)taskExecutorProcessSpec.getFrameworkHeapSize()).isEqualTo((Object)frameworkHeapSize));
    }

    @Test
    void testConfigFrameworkOffHeapMemory() {
        MemorySize frameworkOffHeapSize = MemorySize.parse((String)"10m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY, (Object)frameworkOffHeapSize);
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> Assertions.assertThat((Comparable)taskExecutorProcessSpec.getFrameworkOffHeapMemorySize()).isEqualTo((Object)frameworkOffHeapSize));
    }

    @Test
    void testConfigTaskHeapMemory() {
        MemorySize taskHeapSize = MemorySize.parse((String)"50m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)taskHeapSize);
        this.validateInConfigurationsWithoutExplicitTaskHeapMem(conf, taskExecutorProcessSpec -> Assertions.assertThat((Comparable)taskExecutorProcessSpec.getTaskHeapSize()).isEqualTo((Object)taskHeapSize));
    }

    @Test
    void testConfigTaskOffheapMemory() {
        MemorySize taskOffHeapSize = MemorySize.parse((String)"50m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)taskOffHeapSize);
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> Assertions.assertThat((Comparable)taskExecutorProcessSpec.getTaskOffHeapSize()).isEqualTo((Object)taskOffHeapSize));
    }

    @Test
    void testConfigNetworkMemoryRange() {
        MemorySize networkMin = MemorySize.parse((String)"200m");
        MemorySize networkMax = MemorySize.parse((String)"500m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)networkMax);
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)networkMin);
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> {
            Assertions.assertThat((long)taskExecutorProcessSpec.getNetworkMemSize().getBytes()).isGreaterThanOrEqualTo(networkMin.getBytes());
            Assertions.assertThat((long)taskExecutorProcessSpec.getNetworkMemSize().getBytes()).isLessThanOrEqualTo(networkMax.getBytes());
        });
    }

    @Test
    void testConsistencyCheckOfDerivedNetworkMemoryWithinMinMaxRangeNotMatchingFractionPasses() {
        Configuration configuration = TaskExecutorProcessUtilsTest.setupConfigWithFlinkAndTaskHeapToDeriveGivenNetworkMem(400);
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_FRACTION, (Object)Float.valueOf(0.001f));
        TaskExecutorProcessUtils.processSpecFromConfig((Configuration)configuration);
    }

    @Test
    public void testConsistencyCheckOfDerivedNetworkMemoryLessThanMinFails() {
        Configuration configuration = TaskExecutorProcessUtilsTest.setupConfigWithFlinkAndTaskHeapToDeriveGivenNetworkMem(500);
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)MemorySize.parse((String)"900m"));
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)MemorySize.parse((String)"1000m"));
        Assertions.assertThatExceptionOfType(IllegalConfigurationException.class).isThrownBy(() -> TaskExecutorProcessUtils.processSpecFromConfig((Configuration)configuration));
    }

    @Test
    public void testConsistencyCheckOfDerivedNetworkMemoryGreaterThanMaxFails() {
        Configuration configuration = TaskExecutorProcessUtilsTest.setupConfigWithFlinkAndTaskHeapToDeriveGivenNetworkMem(500);
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)MemorySize.parse((String)"100m"));
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)MemorySize.parse((String)"150m"));
        Assertions.assertThatExceptionOfType(IllegalConfigurationException.class).isThrownBy(() -> TaskExecutorProcessUtils.processSpecFromConfig((Configuration)configuration));
    }

    private static Configuration setupConfigWithFlinkAndTaskHeapToDeriveGivenNetworkMem(int networkMemorySizeToDeriveMb) {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_MEM_SIZE);
        conf.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)TASK_HEAP_SIZE);
        conf.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MANAGED_MEM_SIZE);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)conf);
        int derivedNetworkMemorySizeMb = taskExecutorProcessSpec.getNetworkMemSize().getMebiBytes();
        if (derivedNetworkMemorySizeMb < networkMemorySizeToDeriveMb) {
            int adjustedTotalFlinkMemoryMb = taskExecutorProcessSpec.getTotalFlinkMemorySize().getMebiBytes() - derivedNetworkMemorySizeMb + networkMemorySizeToDeriveMb;
            conf.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)MemorySize.ofMebiBytes((long)adjustedTotalFlinkMemoryMb));
        } else if (derivedNetworkMemorySizeMb > networkMemorySizeToDeriveMb) {
            int adjustedTaskHeapMemoryMb = taskExecutorProcessSpec.getTaskHeapSize().getMebiBytes() + derivedNetworkMemorySizeMb - networkMemorySizeToDeriveMb;
            conf.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)MemorySize.ofMebiBytes((long)adjustedTaskHeapMemoryMb));
        }
        TaskExecutorProcessSpec adjusteedTaskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)conf);
        Assertions.assertThat((int)adjusteedTaskExecutorProcessSpec.getNetworkMemSize().getMebiBytes()).isEqualTo(networkMemorySizeToDeriveMb);
        return conf;
    }

    @Test
    void testConfigNetworkMemoryRangeFailure() {
        MemorySize networkMin = MemorySize.parse((String)"200m");
        MemorySize networkMax = MemorySize.parse((String)"50m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)networkMax);
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)networkMin);
        this.validateFailInAllConfigurations(conf);
    }

    @Test
    void testConfigNetworkMemoryFraction() {
        MemorySize networkMin = MemorySize.ZERO;
        MemorySize networkMax = MemorySize.parse((String)"1t");
        float fraction = 0.2f;
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)networkMax);
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)networkMin);
        conf.set(TaskManagerOptions.NETWORK_MEMORY_FRACTION, (Object)Float.valueOf(0.2f));
        this.validateInConfigWithExplicitTaskHeapAndManagedMem(conf, taskExecutorProcessSpec -> Assertions.assertThat((Comparable)taskExecutorProcessSpec.getNetworkMemSize()).isEqualTo((Object)taskExecutorProcessSpec.getTotalFlinkMemorySize().multiply((double)0.2f)));
    }

    @Test
    void testConfigNetworkMemoryFractionFailure() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.NETWORK_MEMORY_FRACTION, (Object)Float.valueOf(-0.1f));
        this.validateFailInAllConfigurations(conf);
        conf.set(TaskManagerOptions.NETWORK_MEMORY_FRACTION, (Object)Float.valueOf(1.0f));
        this.validateFailInAllConfigurations(conf);
    }

    @Test
    void testConfigManagedMemorySize() {
        MemorySize managedMemSize = MemorySize.parse((String)"100m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)managedMemSize);
        this.validateInConfigurationsWithoutExplicitManagedMem(conf, taskExecutorProcessSpec -> Assertions.assertThat((Comparable)taskExecutorProcessSpec.getManagedMemorySize()).isEqualTo((Object)managedMemSize));
    }

    @Test
    void testConfigManagedMemoryLegacySize() {
        MemorySize managedMemSize = MemorySize.parse((String)"100m");
        ConfigOption legacyOption = TaskManagerOptions.MANAGED_MEMORY_SIZE;
        Configuration conf = new Configuration();
        conf.set(legacyOption, (Object)managedMemSize);
        this.validateInConfigurationsWithoutExplicitManagedMem(conf, taskExecutorProcessSpec -> Assertions.assertThat((Comparable)taskExecutorProcessSpec.getManagedMemorySize()).isEqualTo((Object)managedMemSize));
    }

    @Test
    void testConfigManagedMemoryFraction() {
        float fraction = 0.5f;
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.MANAGED_MEMORY_FRACTION, (Object)Float.valueOf(0.5f));
        this.validateInConfigurationsWithoutExplicitManagedMem(conf, taskExecutorProcessSpec -> Assertions.assertThat((Comparable)taskExecutorProcessSpec.getManagedMemorySize()).isEqualTo((Object)taskExecutorProcessSpec.getTotalFlinkMemorySize().multiply(0.5)));
    }

    @Test
    void testConfigManagedMemoryFractionFailure() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.MANAGED_MEMORY_FRACTION, (Object)Float.valueOf(-0.1f));
        this.validateFailInConfigurationsWithoutExplicitManagedMem(conf);
        conf.set(TaskManagerOptions.MANAGED_MEMORY_FRACTION, (Object)Float.valueOf(1.0f));
        this.validateFailInConfigurationsWithoutExplicitManagedMem(conf);
    }

    @Test
    void testFlinkInternalMemorySizeAddUpFailure() {
        MemorySize totalFlinkMemory = MemorySize.parse((String)"499m");
        MemorySize frameworkHeap = MemorySize.parse((String)"100m");
        MemorySize taskHeap = MemorySize.parse((String)"100m");
        MemorySize taskOffHeap = MemorySize.parse((String)"100m");
        MemorySize network = MemorySize.parse((String)"100m");
        MemorySize managed = MemorySize.parse((String)"100m");
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)totalFlinkMemory);
        conf.set(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, (Object)frameworkHeap);
        conf.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)taskHeap);
        conf.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)taskOffHeap);
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)network);
        conf.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)network);
        conf.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)managed);
        this.validateFail(conf);
    }

    @Test
    void testFlinkInternalMemoryFractionAddUpFailure() {
        float networkFraction = 0.6f;
        float managedFraction = 0.6f;
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.NETWORK_MEMORY_FRACTION, (Object)Float.valueOf(0.6f));
        conf.set(TaskManagerOptions.MANAGED_MEMORY_FRACTION, (Object)Float.valueOf(0.6f));
        this.validateFailInConfigWithExplicitTotalFlinkMem(conf);
        this.validateFailInConfigWithExplicitTotalProcessMem(conf);
    }

    @Test
    void testConfigTotalProcessMemoryLegacySize() {
        MemorySize totalProcessMemorySize = MemorySize.parse((String)"2g");
        ConfigOption legacyOption = TaskManagerOptions.TOTAL_PROCESS_MEMORY;
        Configuration conf = new Configuration();
        conf.set(legacyOption, (Object)totalProcessMemorySize);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)conf);
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getTotalProcessMemorySize()).isEqualTo((Object)totalProcessMemorySize);
    }

    @Test
    public void testExceptionShouldContainRequiredConfigOptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TaskExecutorProcessUtils.processSpecFromConfig((Configuration)new Configuration())).isInstanceOf(IllegalConfigurationException.class)).hasMessageContaining(TaskManagerOptions.TASK_HEAP_MEMORY.key()).hasMessageContaining(TaskManagerOptions.MANAGED_MEMORY_SIZE.key()).hasMessageContaining(TaskManagerOptions.TOTAL_FLINK_MEMORY.key()).hasMessageContaining(TaskManagerOptions.TOTAL_PROCESS_MEMORY.key());
    }

    @Test
    void testConfigNumSlots() {
        int numSlots = 5;
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.NUM_TASK_SLOTS, (Object)5);
        this.validateInAllConfigurations(conf, (TaskExecutorProcessSpec taskExecutorProcessSpec) -> Assertions.assertThat((int)taskExecutorProcessSpec.getNumSlots()).isEqualTo(5));
    }

    @Test
    void testProcessSpecFromConfigWithExternalResource() {
        Configuration config = new Configuration();
        config.setString(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST.key(), EXTERNAL_RESOURCE_NAME_1);
        config.set(ConfigurationUtils.getLongConfigOption((String)ExternalResourceOptions.getAmountConfigOptionForResource((String)EXTERNAL_RESOURCE_NAME_1)), (Object)1L);
        config.set(TaskManagerOptions.TOTAL_PROCESS_MEMORY, (Object)MemorySize.ofMebiBytes((long)4096L));
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
        Assertions.assertThat((Map)taskExecutorProcessSpec.getExtendedResources()).hasSize(1);
        Assertions.assertThat((long)((ExternalResource)taskExecutorProcessSpec.getExtendedResources().get(EXTERNAL_RESOURCE_NAME_1)).getValue().longValue()).isOne();
    }

    @Override
    protected void validateInAllConfigurations(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.validateInConfigWithExplicitTaskHeapAndManagedMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkAndTaskHeapMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkAndManagedMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalProcessMem(customConfig, validateFunc);
    }

    @Override
    protected void validateFailInAllConfigurations(Configuration customConfig) {
        this.validateFailInConfigWithExplicitTaskHeapAndManagedMem(customConfig);
        this.validateFailInConfigWithExplicitTotalFlinkMem(customConfig);
        this.validateFailInConfigWithExplicitTotalFlinkAndTaskHeapMem(customConfig);
        this.validateFailInConfigWithExplicitTotalFlinkAndManagedMem(customConfig);
        this.validateFailInConfigWithExplicitTotalProcessMem(customConfig);
    }

    private void validateInConfigurationsWithoutExplicitTaskHeapMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.validateInConfigWithExplicitTotalFlinkMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkAndManagedMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalProcessMem(customConfig, validateFunc);
    }

    private void validateInConfigurationsWithoutExplicitManagedMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.validateInConfigWithExplicitTotalFlinkMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkAndTaskHeapMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalProcessMem(customConfig, validateFunc);
    }

    private void validateFailInConfigurationsWithoutExplicitManagedMem(Configuration customConfig) {
        this.validateFailInConfigWithExplicitTotalFlinkMem(customConfig);
        this.validateFailInConfigWithExplicitTotalFlinkAndTaskHeapMem(customConfig);
        this.validateFailInConfigWithExplicitTotalProcessMem(customConfig);
    }

    private void validateInConfigWithExplicitTaskHeapAndManagedMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit task heap and managed memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTaskHeapAndManageMem();
        config.addAll(customConfig);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getTaskHeapSize()).isEqualTo((Object)TASK_HEAP_SIZE);
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getManagedMemorySize()).isEqualTo((Object)MANAGED_MEM_SIZE);
        validateFunc.accept(taskExecutorProcessSpec);
    }

    private void validateFailInConfigWithExplicitTaskHeapAndManagedMem(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit task heap and managed memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTaskHeapAndManageMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalFlinkMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit total flink memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalFlinkMem();
        config.addAll(customConfig);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getTotalFlinkMemorySize()).isEqualTo((Object)TOTAL_FLINK_MEM_SIZE);
        validateFunc.accept(taskExecutorProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalFlinkMem(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit total flink memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalFlinkMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalFlinkAndTaskHeapMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit total flink and task heap memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalFlinkAndTaskHeapMem();
        config.addAll(customConfig);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getTotalFlinkMemorySize()).isEqualTo((Object)TOTAL_FLINK_MEM_SIZE);
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getTaskHeapSize()).isEqualTo((Object)TASK_HEAP_SIZE);
        validateFunc.accept(taskExecutorProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalFlinkAndTaskHeapMem(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit total flink and task heap memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalFlinkAndTaskHeapMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalFlinkAndManagedMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit total flink and managed memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalFlinkAndManagedMem();
        config.addAll(customConfig);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getTotalFlinkMemorySize()).isEqualTo((Object)TOTAL_FLINK_MEM_SIZE);
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getManagedMemorySize()).isEqualTo((Object)MANAGED_MEM_SIZE);
        validateFunc.accept(taskExecutorProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalFlinkAndManagedMem(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit total flink and managed memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalFlinkAndManagedMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalProcessMem(Configuration customConfig, Consumer<TaskExecutorProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit total process memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalProcessMem();
        config.addAll(customConfig);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
        Assertions.assertThat((Comparable)taskExecutorProcessSpec.getTotalProcessMemorySize()).isEqualTo((Object)TOTAL_PROCESS_MEM_SIZE);
        validateFunc.accept(taskExecutorProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalProcessMem(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit total process memory size.");
        Configuration config = TaskExecutorProcessUtilsTest.configWithExplicitTotalProcessMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    @Override
    protected void validateFail(Configuration config) {
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IllegalConfigurationException.class).as("Configuration did not fail as expected.", new Object[0])).isThrownBy(() -> TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config));
    }

    @Override
    protected void configWithFineGrainedOptions(Configuration configuration, MemorySize totalFlinkMemorySize) {
        MemorySize componentSize = new MemorySize(totalFlinkMemorySize.getBytes() / 6L);
        configuration.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)componentSize);
        configuration.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)componentSize);
        configuration.set(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, (Object)componentSize);
        configuration.set(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY, (Object)componentSize);
        configuration.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)componentSize);
    }

    private static Configuration configWithExplicitTaskHeapAndManageMem() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)TASK_HEAP_SIZE);
        conf.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MANAGED_MEM_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalFlinkMem() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_MEM_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalFlinkAndTaskHeapMem() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_MEM_SIZE);
        conf.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)TASK_HEAP_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalFlinkAndManagedMem() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_MEM_SIZE);
        conf.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MANAGED_MEM_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalProcessMem() {
        Configuration conf = new Configuration();
        conf.set(TaskManagerOptions.TOTAL_PROCESS_MEMORY, (Object)TOTAL_PROCESS_MEM_SIZE);
        return conf;
    }

    @Override
    protected TaskExecutorProcessSpec processSpecFromConfig(Configuration config) {
        return TaskExecutorProcessUtils.processSpecFromConfig((Configuration)config);
    }
}

