/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.runtime.checkpoint.MappingBasedRepartitioner;
import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MappingBasedRepartitionerTest {
    MappingBasedRepartitionerTest() {
    }

    @Test
    void testBroadcastRedistributeOnScaleDown() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Collections.singletonList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assertions.assertThat(this.repartition(oldStates, SubtaskStateMapper.FULL, 3, 2)).isEqualTo(Arrays.asList(Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1")));
    }

    @Test
    void testBroadcastRedistributeOnNoScale() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Collections.singletonList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assertions.assertThat(this.repartition(oldStates, SubtaskStateMapper.FULL, 3, 3)).isEqualTo(Arrays.asList(Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1")));
    }

    @Test
    void testBroadcastRedistributeOnScaleUp() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Collections.singletonList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assertions.assertThat(this.repartition(oldStates, SubtaskStateMapper.FULL, 3, 4)).isEqualTo(Arrays.asList(Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1")));
    }

    @Test
    void testRangeSelectorRedistributeOnScaleDown() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Collections.singletonList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assertions.assertThat(this.repartition(oldStates, SubtaskStateMapper.RANGE, 3, 2)).isEqualTo(Arrays.asList(Arrays.asList("sub0state0", "sub0state1", "sub1state0"), Arrays.asList("sub1state0", "sub2state0", "sub2state1")));
    }

    @Test
    void testRangeSelectorRedistributeOnNoScale() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Collections.singletonList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assertions.assertThat(this.repartition(oldStates, SubtaskStateMapper.RANGE, 3, 3)).isEqualTo(Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Collections.singletonList("sub1state0"), Arrays.asList("sub2state0", "sub2state1")));
    }

    @Test
    void testRangeSelectorRedistributeOnScaleUp() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Collections.singletonList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assertions.assertThat(this.repartition(oldStates, SubtaskStateMapper.RANGE, 3, 4)).isEqualTo(Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Arrays.asList("sub0state0", "sub0state1", "sub1state0"), Arrays.asList("sub1state0", "sub2state0", "sub2state1"), Arrays.asList("sub2state0", "sub2state1")));
    }

    @Test
    void testRoundRobinRedistributeOnScaleDown() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Collections.singletonList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assertions.assertThat(this.repartition(oldStates, SubtaskStateMapper.ROUND_ROBIN, 3, 2)).isEqualTo(Arrays.asList(Arrays.asList("sub0state0", "sub0state1", "sub2state0", "sub2state1"), Collections.singletonList("sub1state0")));
        Assertions.assertThat(this.repartition(oldStates, SubtaskStateMapper.ROUND_ROBIN, 3, 1)).isEqualTo(Collections.singletonList(Arrays.asList("sub0state0", "sub0state1", "sub1state0", "sub2state0", "sub2state1")));
    }

    @Test
    void testRoundRobinRedistributeOnNoScale() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Collections.singletonList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assertions.assertThat(this.repartition(oldStates, SubtaskStateMapper.ROUND_ROBIN, 3, 3)).isEqualTo(Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Collections.singletonList("sub1state0"), Arrays.asList("sub2state0", "sub2state1")));
    }

    @Test
    void testRoundRobinRedistributeOnScaleUp() {
        List<List<String>> oldStates = Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Collections.singletonList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"));
        Assertions.assertThat(this.repartition(oldStates, SubtaskStateMapper.ROUND_ROBIN, 3, 4)).isEqualTo(Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Collections.singletonList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"), Collections.emptyList()));
        Assertions.assertThat(this.repartition(oldStates, SubtaskStateMapper.ROUND_ROBIN, 3, 5)).isEqualTo(Arrays.asList(Arrays.asList("sub0state0", "sub0state1"), Collections.singletonList("sub1state0"), Arrays.asList("sub2state0", "sub2state1"), Collections.emptyList(), Collections.emptyList()));
    }

    private List<List<String>> repartition(List<List<String>> oldStates, SubtaskStateMapper mapper, int oldParallelism, int newParallelism) {
        return new MappingBasedRepartitioner(mapper.getNewToOldSubtasksMapping(oldParallelism, newParallelism)).repartitionState(oldStates, oldParallelism, newParallelism);
    }
}

