/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.TestingBlobHelpers;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class BlobCacheCorruptionTest {
    @TempDir
    private Path tempDir;

    BlobCacheCorruptionTest() {
    }

    @Test
    void testGetFailsFromCorruptFile1() throws IOException {
        this.testGetFailsFromCorruptFile(null, BlobKey.BlobType.TRANSIENT_BLOB, false);
    }

    @Test
    void testGetFailsFromCorruptFile2() throws IOException {
        this.testGetFailsFromCorruptFile(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB, false);
    }

    @Test
    void testGetFailsFromCorruptFile3() throws IOException {
        this.testGetFailsFromCorruptFile(new JobID(), BlobKey.BlobType.PERMANENT_BLOB, false);
    }

    @Test
    void testGetFailsFromCorruptFile4() throws IOException {
        this.testGetFailsFromCorruptFile(new JobID(), BlobKey.BlobType.PERMANENT_BLOB, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetFailsFromCorruptFile(JobID jobId, BlobKey.BlobType blobType, boolean corruptOnHAStore) throws IOException {
        Configuration config = new Configuration();
        config.set(HighAvailabilityOptions.HA_MODE, (Object)"ZOOKEEPER");
        config.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)TempDirUtils.newFolder((Path)this.tempDir).getPath());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            TestingBlobHelpers.testGetFailsFromCorruptFile(jobId, blobType, corruptOnHAStore, config, (BlobStore)blobStoreService, TempDirUtils.newFolder((Path)this.tempDir));
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.cleanupAllData();
                blobStoreService.close();
            }
        }
    }
}

