/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.asyncprocessing.AsyncRequestContainer;
import org.apache.flink.runtime.asyncprocessing.MockAsyncRequestContainer;
import org.apache.flink.runtime.asyncprocessing.StateExecutor;
import org.apache.flink.runtime.asyncprocessing.StateRequest;
import org.apache.flink.util.Preconditions;

public class MockStateExecutor
implements StateExecutor {
    public CompletableFuture<Void> executeBatchRequests(AsyncRequestContainer<StateRequest<?, ?, ?, ?>> asyncRequestContainer) {
        Preconditions.checkArgument((boolean)(asyncRequestContainer instanceof MockAsyncRequestContainer));
        for (StateRequest request : ((MockAsyncRequestContainer)asyncRequestContainer).getStateRequestList()) {
            this.executeRequestSync(request);
        }
        return CompletableFuture.completedFuture(null);
    }

    public AsyncRequestContainer<StateRequest<?, ?, ?, ?>> createRequestContainer() {
        return new MockAsyncRequestContainer();
    }

    public void executeRequestSync(StateRequest<?, ?, ?, ?> stateRequest) {
        stateRequest.getFuture().complete(null);
    }

    public boolean fullyLoaded() {
        return false;
    }

    public void shutdown() {
    }
}

