/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogram;

class StateMetricBase
implements AutoCloseable {
    protected static final String STATE_NAME_KEY = "state_name";
    protected static final String STATE_CLEAR_LATENCY = "stateClearLatency";
    private final MetricGroup metricGroup;
    private final int sampleInterval;
    private final Map<String, Histogram> histogramMetrics;
    private final Supplier<Histogram> histogramSupplier;
    private int clearCount = 0;

    StateMetricBase(String stateName, MetricGroup metricGroup, int sampleInterval, int historySize, boolean stateNameAsVariable) {
        this.metricGroup = stateNameAsVariable ? metricGroup.addGroup(STATE_NAME_KEY, stateName) : metricGroup.addGroup(stateName);
        this.sampleInterval = sampleInterval;
        this.histogramMetrics = new HashMap<String, Histogram>();
        this.histogramSupplier = () -> new DescriptiveStatisticsHistogram(historySize);
    }

    int getClearCount() {
        return this.clearCount;
    }

    protected boolean trackMetricsOnClear() {
        this.clearCount = this.loopUpdateCounter(this.clearCount);
        return this.clearCount == 1;
    }

    protected int loopUpdateCounter(int counter) {
        return counter + 1 < this.sampleInterval ? counter + 1 : 0;
    }

    protected void updateMetrics(String latencyLabel, long value) {
        this.updateHistogram(latencyLabel, value);
    }

    private void updateHistogram(String metricName, long value) {
        this.histogramMetrics.computeIfAbsent(metricName, k -> {
            Histogram histogram = this.histogramSupplier.get();
            this.metricGroup.histogram(metricName, histogram);
            return histogram;
        }).update(value);
    }

    @Override
    public void close() throws Exception {
        this.histogramMetrics.clear();
    }
}

