/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.InternalOperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

@Internal
public class TaskMetricGroup
extends ComponentMetricGroup<TaskManagerJobMetricGroup> {
    private final Map<String, InternalOperatorMetricGroup> operators = new HashMap<String, InternalOperatorMetricGroup>();
    private final TaskIOMetricGroup ioMetrics;
    private final ExecutionAttemptID executionId;
    protected final JobVertexID vertexId;
    private final String taskName;
    protected final int subtaskIndex;
    private final int attemptNumber;

    TaskMetricGroup(MetricRegistry registry, TaskManagerJobMetricGroup parent, ExecutionAttemptID executionId, String taskName) {
        super(registry, registry.getScopeFormats().getTaskFormat().formatScope((TaskManagerJobMetricGroup)Preconditions.checkNotNull((Object)parent), ((ExecutionAttemptID)Preconditions.checkNotNull((Object)executionId)).getJobVertexId(), (ExecutionAttemptID)Preconditions.checkNotNull((Object)executionId), taskName, ((ExecutionAttemptID)Preconditions.checkNotNull((Object)executionId)).getSubtaskIndex(), ((ExecutionAttemptID)Preconditions.checkNotNull((Object)executionId)).getAttemptNumber()), parent);
        this.executionId = (ExecutionAttemptID)Preconditions.checkNotNull((Object)executionId);
        this.vertexId = executionId.getJobVertexId();
        this.taskName = (String)Preconditions.checkNotNull((Object)taskName);
        this.subtaskIndex = executionId.getSubtaskIndex();
        this.attemptNumber = executionId.getAttemptNumber();
        this.ioMetrics = new TaskIOMetricGroup(this);
    }

    public final TaskManagerJobMetricGroup parent() {
        return (TaskManagerJobMetricGroup)this.parent;
    }

    public ExecutionAttemptID executionId() {
        return this.executionId;
    }

    @Nullable
    public AbstractID vertexId() {
        return this.vertexId;
    }

    @Nullable
    public String taskName() {
        return this.taskName;
    }

    public int subtaskIndex() {
        return this.subtaskIndex;
    }

    public int attemptNumber() {
        return this.attemptNumber;
    }

    public TaskIOMetricGroup getIOMetricGroup() {
        return this.ioMetrics;
    }

    @Override
    protected QueryScopeInfo.TaskQueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        return new QueryScopeInfo.TaskQueryScopeInfo(((TaskManagerJobMetricGroup)this.parent).jobId.toString(), String.valueOf(this.vertexId), this.subtaskIndex, this.attemptNumber);
    }

    public InternalOperatorMetricGroup getOrAddOperator(String operatorName) {
        return this.getOrAddOperator(OperatorID.fromJobVertexID(this.vertexId), operatorName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalOperatorMetricGroup getOrAddOperator(OperatorID operatorID, String operatorName) {
        String truncatedOperatorName = MetricUtils.truncateOperatorName(operatorName);
        String key = operatorID + truncatedOperatorName;
        TaskMetricGroup taskMetricGroup = this;
        synchronized (taskMetricGroup) {
            return this.operators.computeIfAbsent(key, operator -> new InternalOperatorMetricGroup(this.registry, this, operatorID, truncatedOperatorName));
        }
    }

    @Override
    public void close() {
        super.close();
        ((TaskManagerJobMetricGroup)this.parent).removeTaskMetricGroup(this.executionId);
    }

    @Override
    protected void putVariables(Map<String, String> variables) {
        variables.put(ScopeFormat.SCOPE_TASK_VERTEX_ID, this.vertexId.toString());
        variables.put(ScopeFormat.SCOPE_TASK_NAME, this.taskName);
        variables.put(ScopeFormat.SCOPE_TASK_ATTEMPT_ID, this.executionId.toString());
        variables.put(ScopeFormat.SCOPE_TASK_ATTEMPT_NUM, String.valueOf(this.attemptNumber));
        variables.put(ScopeFormat.SCOPE_TASK_SUBTASK_INDEX, String.valueOf(this.subtaskIndex));
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup<?>> subComponents() {
        return this.operators.values();
    }

    @Override
    protected String getGroupName(CharacterFilter filter) {
        return "task";
    }
}

